/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.validator;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.WebFetcher;
import com.lucidworks.connector.plugins.web.fetcher.http.client.WebClient;
import com.lucidworks.connector.plugins.web.fetcher.http.client.WebClientResponse;
import com.lucidworks.connector.plugins.web.fetcher.http.tokenauth.AccessTokenRequestParam;
import com.lucidworks.fusion.connector.plugin.api.config.ConnectorConfig;
import com.lucidworks.fusion.connector.plugin.api.validation.ValidationComponent;
import com.lucidworks.fusion.connector.plugin.api.validation.ValidationContext;
import com.lucidworks.fusion.connector.plugin.api.validation.result.ConnectorConfigValidationResult;
import com.lucidworks.fusion.schema.ValidationError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebValidator
implements ValidationComponent {
    private static final Logger logger = LoggerFactory.getLogger(WebValidator.class);
    private final WebConfig config;
    private final WebClient client;
    private final Boolean infiniteTimeout;
    private final Integer timeout;

    @Inject
    public WebValidator(WebConfig config, WebClient client) {
        this.config = config;
        this.client = client;
        this.infiniteTimeout = config.properties().crawlPerformanceConfig().infiniteTimeout();
        this.timeout = this.infiniteTimeout != false ? 0 : config.properties().crawlPerformanceConfig().timeoutMS();
    }

    public ConnectorConfigValidationResult validateConfig(ValidationContext validationContext) {
        Integer implicitWaitTimeout;
        Integer scriptTimeout;
        String chromeExtraCommandLineArgs;
        logger.info("Validating connector configuration...");
        HashSet<ValidationError> errors = new HashSet<ValidationError>();
        logger.info("Validating Selenium infrastructure availability");
        if (!this.validateSeleniumInfrastructure(errors)) {
            return ((ConnectorConfigValidationResult.Builder)ConnectorConfigValidationResult.builder((ConnectorConfig)this.config).withErrors(errors)).build();
        }
        if (this.config.properties().crawlAuthenticationConfig() != null && this.config.properties().crawlAuthenticationConfig().accessTokenConfig() != null && this.config.properties().crawlAuthenticationConfig().accessTokenConfig().requestUrl() != null) {
            List params = this.config.properties().crawlAuthenticationConfig().accessTokenConfig().params().stream().map(AccessTokenRequestParam::name).collect(Collectors.toList());
            this.config.properties().crawlAuthenticationConfig().accessTokenConfig().secretParams().stream().filter(p -> params.contains(p.name())).forEach(p -> errors.add(new ValidationError("Secret Parameters", (Object)p.name(), "duplicate", String.format("Secret parameter %s is already defined in the parameter list", p.name()))));
        }
        List<String> startLinks = this.config.properties().startLinks();
        List<String> bulkStartLinkList = WebFetcher.bulkStartLinkList(this.config);
        List<String> sitemapURLs = this.config.properties().linkDiscoveryConfig().sitemapURLs();
        logger.info("Validating start links");
        ArrayList linkErrors = new ArrayList();
        if (!startLinks.isEmpty() && startLinks.stream().noneMatch(l -> this.checkLink((String)l, linkErrors))) {
            errors.add(new ValidationError("startLinks", startLinks, "invalid-url", "Cannot connect to any of the provided start links. Errors: " + linkErrors));
        }
        logger.info("Validating bulk start links");
        if (!bulkStartLinkList.isEmpty() && bulkStartLinkList.stream().noneMatch(l -> this.checkLink((String)l, linkErrors))) {
            errors.add(new ValidationError("bulkStartLinkList", bulkStartLinkList, "invalid-url", "Cannot connect to any of the provided bulk start links. Errors: " + linkErrors));
        }
        logger.info("Validating sitemap URLs");
        if (!sitemapURLs.isEmpty() && sitemapURLs.stream().noneMatch(l -> this.checkLink((String)l, linkErrors))) {
            errors.add(new ValidationError("sitemapURLs", sitemapURLs, "invalid-url", "Cannot connect to any of the provided sitemap URLs. Errors: " + linkErrors));
        }
        if (StringUtils.isNotBlank((CharSequence)(chromeExtraCommandLineArgs = this.config.properties().javascriptEvaluationConfig().chromeExtraCommandLineArgs()))) {
            for (String extraCommandLineArg : chromeExtraCommandLineArgs.split("\\s+")) {
                if (StringUtils.startsWith((CharSequence)extraCommandLineArg, (CharSequence)"--")) continue;
                errors.add(new ValidationError("chromeExtraCommandLineArgs", (Object)chromeExtraCommandLineArgs, "value-not-allowed", "Extra command line arguments must be of form --argname[=value]"));
            }
        }
        if ((scriptTimeout = this.config.properties().javascriptEvaluationConfig().jsScriptTimeout()) != null && scriptTimeout > 0) {
            if (scriptTimeout < 1000) {
                errors.add(new ValidationError("jsScriptTimeout", (Object)scriptTimeout, "value-not-allowed", "Script timeout must be at least 1000ms (1 second)"));
            } else if (scriptTimeout > 300000) {
                errors.add(new ValidationError("jsScriptTimeout", (Object)scriptTimeout, "value-not-allowed", "Script timeout cannot exceed 300000ms (5 minutes)"));
            }
        }
        if ((implicitWaitTimeout = this.config.properties().javascriptEvaluationConfig().jsImplicitWaitTimeout()) != null && implicitWaitTimeout > 0) {
            if (implicitWaitTimeout < 100) {
                errors.add(new ValidationError("jsImplicitWaitTimeout", (Object)implicitWaitTimeout, "value-not-allowed", "Implicit wait timeout must be at least 100ms"));
            } else if (implicitWaitTimeout > 60000) {
                errors.add(new ValidationError("jsImplicitWaitTimeout", (Object)implicitWaitTimeout, "value-not-allowed", "Implicit wait timeout cannot exceed 60000ms (1 minute)"));
            }
        }
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new WebConnectorException("Failed to close WebClient", e);
        }
        return ((ConnectorConfigValidationResult.Builder)ConnectorConfigValidationResult.builder((ConnectorConfig)this.config).withErrors(errors)).build();
    }

    private boolean checkLink(String link, List<String> errors) {
        int status;
        try {
            WebClientResponse resp = this.client.fetchWithRedirects(link, 0);
            status = resp.getStatus();
        }
        catch (Exception e) {
            logger.error("Error validating start link.", (Throwable)e);
            errors.add(link + " : " + e.getMessage());
            return false;
        }
        if ((status < 200 || status > 300) && status != 304) {
            errors.add(link + " : HTTP status " + status);
            return false;
        }
        return true;
    }

    private boolean validateSeleniumInfrastructure(Set<ValidationError> errors) {
        if (!this.config.properties().javascriptEvaluationConfig().crawlJS().booleanValue()) {
            logger.debug("JavaScript evaluation disabled, skipping Selenium infrastructure validation");
            return true;
        }
        String seleniumHubUrl = "http://selenium-hub:4444/wd/hub/status";
        try {
            if (!this.isServiceAccessible(seleniumHubUrl)) {
                errors.add(new ValidationError("javascriptEvaluationConfig.crawlJS", (Object)true, "SELENIUM_HUB_UNAVAILABLE", "JavaScript evaluation is enabled but Selenium hub is not accessible at " + seleniumHubUrl + ". Ensure Selenium hub pods are running and accessible."));
            } else {
                logger.info("Selenium hub is accessible and ready");
            }
        }
        catch (Exception e) {
            logger.warn("Error checking Selenium hub availability: {}", (Object)e.getMessage());
            errors.add(new ValidationError("javascriptEvaluationConfig.crawlJS", (Object)true, "SELENIUM_HUB_CHECK_FAILED", "Failed to check Selenium hub availability: " + e.getMessage() + ". Ensure Selenium hub pods are running and network connectivity is available."));
        }
        String gridApiUrl = "http://selenium-hub:4444/wd/hub/status";
        try {
            if (!this.hasChromeNodesRegistered(gridApiUrl)) {
                errors.add(new ValidationError("javascriptEvaluationConfig.crawlJS", (Object)true, "SELENIUM_CHROME_NODES_UNAVAILABLE", "JavaScript evaluation is enabled but no Chrome nodes are registered with Selenium hub. Ensure Chrome node pods are running and have registered with the hub."));
            } else {
                logger.info("Chrome nodes are registered with Selenium hub and ready");
            }
        }
        catch (Exception e) {
            logger.warn("Error checking Chrome nodes registration: {}", (Object)e.getMessage());
            errors.add(new ValidationError("javascriptEvaluationConfig.crawlJS", (Object)true, "SELENIUM_CHROME_NODES_CHECK_FAILED", "Failed to check Chrome nodes registration with Selenium hub: " + e.getMessage() + ". Ensure Chrome node pods are running and can communicate with the hub."));
        }
        return errors.isEmpty();
    }

    private boolean hasChromeNodesRegistered(String gridApiUrl) {
        try {
            String responseBody = this.fetchUrl(gridApiUrl);
            if (responseBody == null) {
                return false;
            }
            return this.parseChromeNodeResponse(responseBody);
        }
        catch (Exception e) {
            logger.debug("Failed to check Chrome nodes registration: {}", (Object)e.getMessage());
            return false;
        }
    }

    protected boolean parseChromeNodeResponse(String responseBody) {
        if (responseBody == null || responseBody.trim().isEmpty()) {
            return false;
        }
        logger.debug("Selenium hub status response: {}", (Object)responseBody);
        String lowerResponse = responseBody.toLowerCase();
        boolean hasChromeCapability = lowerResponse.contains("\"browsername\":\"chrome\"") || lowerResponse.contains("\"browsername\": \"chrome\"") || lowerResponse.contains("\"browser\":\"chrome\"") || lowerResponse.contains("chrome") || lowerResponse.contains("\"chrome\"");
        boolean hasReadyStatus = lowerResponse.contains("\"ready\":true") || lowerResponse.contains("\"ready\": true") || lowerResponse.contains("\"availability\":\"up\"") || lowerResponse.contains("\"availability\": \"up\"") || lowerResponse.contains("\"status\":\"up\"") || lowerResponse.contains("ready") || lowerResponse.contains("\"up\"") || lowerResponse.contains("available");
        boolean hasNodeStructure = lowerResponse.contains("\"nodes\"") || lowerResponse.contains("\"slots\"") || lowerResponse.contains("\"total\":") || lowerResponse.contains("\"grid\"") || lowerResponse.contains("\"hub\"");
        boolean hasValidResponse = responseBody.length() > 10;
        logger.debug("Chrome validation - hasChromeCapability: {}, hasReadyStatus: {}, hasNodeStructure: {}, responseLength: {}", new Object[]{hasChromeCapability, hasReadyStatus, hasNodeStructure, responseBody.length()});
        return hasChromeCapability && (hasReadyStatus || hasNodeStructure) && hasValidResponse;
    }

    private boolean isServiceAccessible(String serviceUrl) {
        return this.fetchUrl(serviceUrl) != null;
    }

    protected String fetchUrl(String url) {
        try {
            URL urlObj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("GET");
            int timeoutValue = this.infiniteTimeout != false ? 0 : this.timeout;
            connection.setConnectTimeout(timeoutValue);
            connection.setReadTimeout(timeoutValue);
            int responseCode = connection.getResponseCode();
            logger.debug("Service status check for {} returned: {}", (Object)url, (Object)responseCode);
            if (responseCode != 200) {
                logger.debug("Service returned non-200 response: {}", (Object)responseCode);
                return null;
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            return response.toString();
        }
        catch (IOException e) {
            logger.debug("Failed to connect to service {}: {}", (Object)url, (Object)e.getMessage());
            return null;
        }
    }
}

