/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.util;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.lucidworks.connector.plugins.web.fetcher.http.client.WebFetcherHttpRequestRetryHandler;
import com.lucidworks.connector.plugins.web.fetcher.http.login.HttpCredential;
import com.lucidworks.connector.plugins.web.util.DateUtil;
import com.lucidworks.connector.plugins.web.util.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    public static final String FETCHED_ID = "fetchedID";
    public static final String MIME_TYPE = "mimeType";
    public static final String CHAR_SET = "charSet";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String ETAG = "etag";
    public static final String CONTENT_LENGTH = "contentLength";
    public static final String HEADERS = "headers";
    public static final String ANY_HOST = "*";
    private static final ThreadLocal<SimpleDateFormat> HTTP_DATE_FORMATTER = ThreadLocal.withInitial(DateUtil::getRFC2822DateFormatter);

    private HttpClientUtil() {
    }

    public static HttpClientConnectionManager makeConnectionManager(int threadCount, boolean allowAllCertificates, boolean useIpAddressForSslConnections) {
        SSLContext sslContext = SSLContexts.createSystemDefault();
        DefaultHostnameVerifier sslHostVerifier = new DefaultHostnameVerifier();
        if (allowAllCertificates) {
            try {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(HttpClientUtil.getDefaultKeyManagers(), new TrustManager[]{new X509ExtendedTrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                    }
                }}, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                logger.warn("Failed to create an allow-all TrustManager, using the system default!", (Throwable)e);
                sslContext = SSLContexts.createSystemDefault();
            }
            sslHostVerifier = new NoopHostnameVerifier();
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)sslHostVerifier);
        if (useIpAddressForSslConnections && allowAllCertificates) {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)sslHostVerifier){

                public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                    return super.connectSocket(connectTimeout, socket, new HttpHost(remoteAddress.getAddress().getHostAddress(), remoteAddress.getPort()), remoteAddress, localAddress, context);
                }
            };
        }
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build());
        manager.setValidateAfterInactivity(10000);
        int defaultMaxPerRoute = Integer.parseInt(System.getProperty("com.lucidworks.httpclient.defaultMaxPerRoute", "1000"));
        int maxTotalConnections = Integer.parseInt(System.getProperty("com.lucidworks.httpclient.maxTotalConnections", "1000"));
        maxTotalConnections = Math.max(maxTotalConnections, threadCount * defaultMaxPerRoute);
        logger.info("HTTP Client Connection Manager settings: defaultMaxPerRoute={}, maxTotalConnections={}", (Object)defaultMaxPerRoute, (Object)maxTotalConnections);
        manager.setDefaultMaxPerRoute(defaultMaxPerRoute);
        manager.setMaxTotal(maxTotalConnections);
        return manager;
    }

    public static HttpClientBuilder makeClientBuilder(HttpClientConnectionManager manager, int timeoutMS, boolean infiniteTimeout, int requestRetryCount, String proxy, String userAgent, String cookieSpec, BasicCookieStore cookieStore, boolean allowCircularRedirects) {
        ArrayList targetPreferredAuthSchemes = Lists.newArrayList((Object[])new String[]{"Digest", "NTLM", "Basic", "Negotiate", "Kerberos"});
        int connectTimeout = 60000;
        int connectionRequestTimeout = 60000;
        int socketTimeout = infiniteTimeout ? 0 : timeoutMS;
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec(null == cookieSpec ? "standard" : cookieSpec).setExpectContinueEnabled(true).setTargetPreferredAuthSchemes((Collection)targetPreferredAuthSchemes).setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setCircularRedirectsAllowed(allowCircularRedirects).build();
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(manager).setDefaultCookieStore((CookieStore)cookieStore).setDefaultRequestConfig(defaultRequestConfig).setUserAgent(userAgent).setRedirectStrategy((RedirectStrategy)new CustomRedirectStrategy());
        builder = requestRetryCount > 0 ? builder.setRetryHandler((HttpRequestRetryHandler)new WebFetcherHttpRequestRetryHandler(requestRetryCount)) : builder.disableAutomaticRetries();
        if (null != proxy && !proxy.isEmpty()) {
            int proxyPort;
            String[] proxyParts = proxy.split(":");
            if (proxyParts.length < 2) {
                throw new RuntimeException("Invalid proxy: '" + proxy + "'; specify proxy in <host>:<port> format");
            }
            try {
                proxyPort = Integer.parseInt(proxyParts[1]);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid proxy port: '" + proxyParts[1] + "'", e);
            }
            builder.setProxy(new HttpHost(proxyParts[0], proxyPort));
        }
        return builder;
    }

    public static HttpResponse request(HttpClient client, HttpUriRequest request, HttpContext context, ExecutorService executor, int timeoutMS) throws TimeoutException, InterruptedException, ExecutionException {
        return HttpClientUtil.request(client, request, context, executor, timeoutMS, false);
    }

    public static HttpResponse request(HttpClient client, HttpUriRequest request, HttpContext context, ExecutorService executor, int timeoutMS, boolean infiniteTimeout) throws TimeoutException, InterruptedException, ExecutionException {
        HttpResponse response;
        Future<HttpResponse> future = null;
        try {
            future = executor.submit(new ExecuteCallable(client, request, context));
            response = infiniteTimeout ? future.get() : future.get(timeoutMS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            request.abort();
            if (future != null) {
                future.cancel(true);
            }
            throw e;
        }
        return response;
    }

    public static byte[] readEntity(HttpUriRequest request, HttpResponse response, ExecutorService executor, int timeoutMS) throws TimeoutException, InterruptedException, ExecutionException {
        return HttpClientUtil.readEntity(request, response, executor, timeoutMS, false);
    }

    public static byte[] readEntity(HttpUriRequest request, HttpResponse response, ExecutorService executor, int timeoutMS, boolean infiniteTimeout) throws TimeoutException, InterruptedException, ExecutionException {
        byte[] entity;
        Future<byte[]> future = null;
        try {
            future = executor.submit(new ReadEntityCallable(response));
            entity = infiniteTimeout ? future.get() : (timeoutMS > 0 ? future.get(timeoutMS, TimeUnit.MILLISECONDS) : future.get());
        }
        catch (InterruptedException | TimeoutException e) {
            request.abort();
            if (future != null) {
                future.cancel(true);
            }
            throw e;
        }
        return entity;
    }

    public static Map<String, Object> parseResponseMetadata(HttpUriRequest req, HttpResponse resp, HttpContext context) throws MalformedURLException, URISyntaxException {
        HttpEntity entity = resp.getEntity();
        HashMap<String, Object> parsedRespMap = new HashMap<String, Object>();
        URI fetchedID = new URI(req.getRequestLine().getUri());
        RedirectLocations r = (RedirectLocations)context.getAttribute("http.protocol.redirect-locations");
        if (null != r && !r.isEmpty()) {
            fetchedID = (URI)r.getAll().get(r.size() - 1);
        }
        parsedRespMap.put(FETCHED_ID, fetchedID.toURL().toExternalForm());
        HttpClientUtil.addContentType(entity, parsedRespMap);
        Header lastModifiedHeader = resp.getFirstHeader("Last-Modified");
        HttpClientUtil.addLastModified(lastModifiedHeader, parsedRespMap);
        Header etagHeader = resp.getFirstHeader("ETag");
        if (null != etagHeader) {
            parsedRespMap.put(ETAG, etagHeader.getValue());
        }
        if (null != entity) {
            parsedRespMap.put(CONTENT_LENGTH, entity.getContentLength());
        }
        if (null != resp.getAllHeaders()) {
            parsedRespMap.put(HEADERS, Arrays.asList(resp.getAllHeaders()));
        }
        return parsedRespMap;
    }

    private static void addContentType(HttpEntity entity, Map<String, Object> parsedRespMap) {
        if (null == entity) {
            return;
        }
        try {
            ContentType contentType = ContentType.get((HttpEntity)entity);
            if (null != contentType) {
                Charset charSet;
                String mimeType = contentType.getMimeType();
                if (null != mimeType) {
                    parsedRespMap.put(MIME_TYPE, mimeType);
                }
                if (null != (charSet = contentType.getCharset())) {
                    parsedRespMap.put(CHAR_SET, charSet.displayName());
                }
            }
        }
        catch (IllegalCharsetNameException ex) {
            logger.debug("Problem reading Content-Type from the header", (Throwable)ex);
            parsedRespMap.put(MIME_TYPE, "text/html");
            parsedRespMap.put(CHAR_SET, "utf-8");
            logger.warn("Problem reading Content-Type from the header '{}', using defaults ('text/html', 'utf-8')", (Object)ex.getMessage());
        }
    }

    private static void addLastModified(Header lastModifiedHeader, Map<String, Object> parsedRespMap) {
        if (null == lastModifiedHeader) {
            return;
        }
        long lastModified = 0L;
        try {
            lastModified = HTTP_DATE_FORMATTER.get().parse(lastModifiedHeader.getValue()).getTime();
        }
        catch (ParseException e) {
            logger.warn("Unable to parse last-modified date: {}", (Object)lastModifiedHeader.getValue(), (Object)e);
        }
        parsedRespMap.put(LAST_MODIFIED, lastModified);
    }

    public static CredentialsProvider makeCredentialsProvider(HttpCredential[] credentials) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        block9: for (HttpCredential credential : credentials) {
            String host = credential.getHost();
            if (ANY_HOST.equals(StringUtils.trim((String)host))) {
                host = AuthScope.ANY_HOST;
            }
            switch (credential.getType().toLowerCase()) {
                case "basic": 
                case "digest": {
                    credentialsProvider.setCredentials(new AuthScope(host, credential.getPort(), credential.getRealm()), (Credentials)new UsernamePasswordCredentials(credential.getUserName(), credential.getPassword()));
                    if (!logger.isDebugEnabled()) continue block9;
                    logger.debug("Adding credential: [ type={} host={} port={} realm={} userName={} ]", new Object[]{credential.getType().toUpperCase(), host, credential.getPort(), credential.getRealm(), credential.getUserName()});
                    continue block9;
                }
                case "ntlm": {
                    credentialsProvider.setCredentials(new AuthScope(host, credential.getPort(), credential.getRealm()), (Credentials)new NTCredentials(credential.getUserName(), credential.getPassword(), credential.getWorkstation(), credential.getDomain()));
                    if (!logger.isDebugEnabled()) continue block9;
                    logger.debug("Adding credential: [ type={} host={} port={} realm={} domain={} workstation={} userName={} ]", new Object[]{credential.getType().toUpperCase(), host, credential.getPort(), credential.getRealm(), credential.getDomain(), credential.getWorkstation(), credential.getUserName()});
                    continue block9;
                }
            }
        }
        return credentialsProvider;
    }

    private static KeyManager[] getDefaultKeyManagers() {
        if (System.getProperties().get("javax.net.ssl.keyStore") != null) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance(System.getProperties().getProperty("javax.net.ssl.keyStoreType", "JKS"));
                char[] ksPass = System.getProperties().getProperty("javax.net.ssl.keyStorePassword").toCharArray();
                FileInputStream fis = new FileInputStream(System.getProperties().getProperty("javax.net.ssl.keyStore", "keystore.jks"));
                ks.load(fis, ksPass);
                kmf.init(ks, ksPass);
                fis.close();
                return kmf.getKeyManagers();
            }
            catch (Exception e) {
                logger.warn("Unable to initialize keystore", (Throwable)e);
            }
        }
        return null;
    }

    public static void putAddedHeadersIntoHttpGet(HttpGet req, String addedHeaders) {
        if (StringUtils.isNotBlank((CharSequence)addedHeaders)) {
            for (String nextHeaderLine : addedHeaders.split("\\r?\\n")) {
                String[] nextHeaderLineSplit = nextHeaderLine.split(": ");
                if (nextHeaderLineSplit.length != 2) continue;
                req.addHeader(nextHeaderLineSplit[0], nextHeaderLineSplit[1]);
            }
        }
    }

    public static class CustomRedirectStrategy
    extends LaxRedirectStrategy {
        protected URI createLocationURI(String location) throws ProtocolException {
            String newLocation = location;
            try {
                new URI(newLocation);
            }
            catch (URISyntaxException ex) {
                logger.warn("Redirected URL: [ {} ] will be encoded", (Object)newLocation);
                newLocation = Utils.encodeURL(newLocation);
            }
            return super.createLocationURI(newLocation);
        }
    }

    private static class ReadEntityCallable
    implements Callable<byte[]> {
        private final HttpResponse response;

        public ReadEntityCallable(HttpResponse response) {
            this.response = response;
        }

        @Override
        public byte[] call() throws IOException {
            return EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
        }
    }

    private static class ExecuteCallable
    implements Callable<HttpResponse> {
        private final HttpClient client;
        private final HttpUriRequest request;
        private final HttpContext context;

        public ExecuteCallable(HttpClient client, HttpUriRequest request, HttpContext context) {
            this.client = client;
            this.request = request;
            this.context = context;
        }

        @Override
        public HttpResponse call() throws IOException {
            HttpResponse response;
            try {
                response = this.client.execute(this.request, this.context);
                if (logger.isTraceEnabled()) {
                    Optional<String> redirects = this.getRedirectURLs(this.context);
                    if (redirects.isPresent()) {
                        logger.trace("Redirect URLs for request: [{}]: {}", (Object)this.request.getURI(), (Object)redirects.get());
                    } else {
                        logger.trace("No redirect URLs for request: [{}]", (Object)this.request.getURI());
                    }
                }
            }
            catch (Exception e) {
                boolean isCircularException = Throwables.getCausalChain((Throwable)e).stream().anyMatch(t -> t instanceof CircularRedirectException);
                if (isCircularException) {
                    Optional<String> urls = this.getRedirectURLs(this.context);
                    logger.error("Circular redirect URLs for request: [{}]: {}", (Object)this.request.getURI(), (Object)(urls.isPresent() ? urls.get() : "Unable to trace redirects"));
                }
                throw e;
            }
            return response;
        }

        private Optional<String> getRedirectURLs(HttpContext context) {
            RedirectLocations redirectLocations = (RedirectLocations)context.getAttribute("http.protocol.redirect-locations");
            if (redirectLocations != null && !redirectLocations.isEmpty()) {
                List urlsList = redirectLocations.getAll().stream().map(URI::toString).collect(Collectors.toList());
                return Optional.of(String.join((CharSequence)", ", urlsList));
            }
            return Optional.empty();
        }
    }
}

