/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.webdriver;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.webdriver.PoolableWebDriver;
import com.lucidworks.connector.plugins.web.fetcher.webdriver.SeleniumSessionCleanUp;
import com.lucidworks.connector.plugins.web.fetcher.webdriver.WebDriverPool;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebDriverPool
implements WebDriverPool {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebDriverPool.class);
    public static final String HUB_URL = "http://selenium-hub:4444/wd/hub";
    static String hubUrl = "http://selenium-hub:4444/wd/hub";
    private final WebConfig config;
    private final SeleniumSessionCleanUp sessionCleanUp;
    private volatile boolean isShutdown;
    private final BlockingQueue<PoolableWebDriver> queue = new LinkedBlockingQueue<PoolableWebDriver>();
    private final Set<PoolableWebDriver> pool = Collections.synchronizedSet(new HashSet());
    private boolean initialized;
    private int poolSize;

    @Inject
    public DefaultWebDriverPool(WebConfig config, SeleniumSessionCleanUp sessionCleanUp) {
        this.config = config;
        this.sessionCleanUp = sessionCleanUp;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.sessionCleanUp.runCleanUp();
        try {
            this.poolSize = this.getTotalGridCapacity();
        }
        catch (Exception e) {
            String message = String.format("Failed to get grid capacity: %s", e.getMessage());
            throw new WebConnectorException(message, e);
        }
        if (this.poolSize == 0) {
            throw new WebConnectorException("Pool size is 0");
        }
        logger.info("Initialized web driver pool with size: {}", (Object)this.poolSize);
        this.initialized = true;
    }

    @Override
    public PoolableWebDriver borrowDriver() {
        PoolableWebDriver driver;
        this.initialize();
        try {
            this.addNewWebDriver();
            driver = this.queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebConnectorException("Could not borrow a web driver from pool", e);
        }
        try {
            driver.getWebDriver().getCurrentUrl();
            driver.getWebDriver().getSessionId();
        }
        catch (Exception e) {
            logger.debug("Session appears to be invalid: {}", (Object)e.getMessage());
            this.destroyDriver(driver);
            driver = this.newWebDriver();
        }
        return driver;
    }

    private synchronized void addNewWebDriver() throws InterruptedException {
        if (this.poolSize > this.pool.size() && this.queue.size() < this.poolSize) {
            this.queue.put(this.newWebDriver());
        }
    }

    @Override
    public void returnDriver(PoolableWebDriver driver) {
        if (driver == null || driver.isRemoved()) {
            return;
        }
        try {
            this.queue.put(driver);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebConnectorException("Could not return driver", e);
        }
    }

    @Override
    public void shutdown() {
        logger.info("Shutting down WebDriver pool {}", this.pool);
        this.isShutdown = true;
        for (PoolableWebDriver webDriver : this.pool) {
            logger.info("Quitting WebDriver {}", (Object)webDriver);
            webDriver.getWebDriver().quit();
        }
        this.queue.clear();
        this.pool.clear();
        this.sessionCleanUp.runCleanUp();
        logger.info("WebDriver pool shutdown complete.");
    }

    @Override
    public void destroyDriver(PoolableWebDriver driver) {
        try {
            driver.quit();
            logger.info("Destroyed WebDriver");
        }
        catch (Exception e) {
            logger.warn("Error destroying WebDriver: {}", (Object)e.getMessage());
        }
        finally {
            this.pool.remove(driver);
        }
    }

    protected PoolableWebDriver newWebDriver() {
        if (this.isShutdown) {
            throw new WebConnectorException("WebDriver pool is shutdown");
        }
        try {
            RemoteWebDriver driver = this.createWebDriverInstance();
            PoolableWebDriver poolableWebDriver = new PoolableWebDriver(driver);
            this.pool.add(poolableWebDriver);
            this.configureWebDriver(driver);
            logger.info("Created new WebDriver, current pool:" + this.queue);
            return poolableWebDriver;
        }
        catch (Exception e) {
            throw new WebConnectorException("Failed to create WebDriver", e);
        }
    }

    public RemoteWebDriver createWebDriverInstance() throws Exception {
        DesiredCapabilities capabilities = this.createCapabilities();
        return new RemoteWebDriver(URI.create(HUB_URL).toURL(), (Capabilities)capabilities);
    }

    public DesiredCapabilities createCapabilities() {
        ChromeOptions options = this.getChromeOptions();
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setBrowserName("chrome");
        capabilities.setCapability("goog:chromeOptions", (Object)options);
        String proxyString = this.config.properties().crawlAuthenticationConfig().proxy();
        if (!StringUtils.isBlank((CharSequence)proxyString)) {
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxyString);
            proxy.setSslProxy(proxyString);
            capabilities.setCapability("proxy", (Object)proxy);
        }
        return capabilities;
    }

    protected void configureWebDriver(RemoteWebDriver driver) {
        int scriptTimeout = this.config.properties().javascriptEvaluationConfig().jsScriptTimeout();
        int implicitWait = this.config.properties().javascriptEvaluationConfig().jsImplicitWaitTimeout();
        boolean infiniteTimeout = this.config.properties().crawlPerformanceConfig().infiniteTimeout();
        long pageLoadTimeoutMs = infiniteTimeout ? Duration.ofHours(24L).toMillis() : (long)this.config.properties().crawlPerformanceConfig().timeoutMS().intValue();
        driver.manage().timeouts().pageLoadTimeout(Duration.ofMillis(pageLoadTimeoutMs)).scriptTimeout(Duration.ofMillis(scriptTimeout)).implicitlyWait(Duration.ofMillis(implicitWait));
        logger.info("Configured WebDriver timeouts - Page load: {}ms (infinite: {}), Script: {}ms, Implicit wait: {}ms", new Object[]{pageLoadTimeoutMs, infiniteTimeout, scriptTimeout, implicitWait});
    }

    protected ChromeOptions getChromeOptions() {
        ChromeOptions options = new ChromeOptions();
        if (BooleanUtils.isTrue((Boolean)this.config.properties().javascriptEvaluationConfig().headlessBrowser())) {
            options.addArguments(new String[]{"--headless=new"});
        }
        int deviceScreenFactor = this.config.properties().javascriptEvaluationConfig().deviceScreenFactor();
        options.addArguments(new String[]{"--deviceScreenFactor=" + deviceScreenFactor});
        int viewportWidth = this.config.properties().javascriptEvaluationConfig().viewportWidth();
        options.addArguments(new String[]{"--viewportWidth=" + viewportWidth});
        int viewportHeight = this.config.properties().javascriptEvaluationConfig().viewportHeight();
        options.addArguments(new String[]{"--viewportHeight=" + viewportHeight});
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"--disable-extensions"});
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.addArguments(new String[]{"--ignore-certificate-errors"});
        options.addArguments(new String[]{"--disable-web-security"});
        options.addArguments(new String[]{"--disable-infobars"});
        options.addArguments(new String[]{"--dns-prefetch-disable"});
        options.addArguments(new String[]{"--disable-features=NetworkService"});
        options.setExperimentalOption("w3c", (Object)true);
        String chromeExtraCommandLineArgs = this.config.properties().javascriptEvaluationConfig().chromeExtraCommandLineArgs();
        if (chromeExtraCommandLineArgs != null) {
            for (String extraCommandLineArg : chromeExtraCommandLineArgs.split("\\s+")) {
                if (extraCommandLineArg.trim().isEmpty()) continue;
                options.addArguments(new String[]{extraCommandLineArg});
            }
        }
        return options;
    }

    public int getTotalGridCapacity() throws Exception {
        URL url = new URL(hubUrl + "/status");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        InputStream responseStream = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(responseStream);
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
        JsonArray nodes = json.getAsJsonObject("value").getAsJsonArray("nodes");
        int totalCapacity = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            JsonObject node = nodes.get(i).getAsJsonObject();
            logger.info("Selenium worker node found: {}", (Object)node.toString());
            totalCapacity += node.get("maxSessions").getAsInt();
        }
        reader.close();
        return totalCapacity;
    }
}

