/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.sitemap;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.http.client.LinkChecker;
import com.lucidworks.connector.plugins.web.fetcher.sitemap.SitemapClient;
import com.lucidworks.connector.plugins.web.fetcher.sitemap.SitemapLink;
import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitemapLinks {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SitemapLinks.class);
    private final SitemapClient client;
    private final LinkChecker linkChecker;
    private final WebConfig config;
    private final Map<String, SitemapLink> linkMap = new HashMap<String, SitemapLink>();
    private volatile boolean initialized;

    @Inject
    public SitemapLinks(WebConfig config, SitemapClient client, LinkChecker linkChecker) {
        this.config = config;
        this.client = client;
        this.linkChecker = linkChecker;
    }

    public synchronized Map<String, SitemapLink> getAllLinks() {
        if (this.initialized) {
            return this.linkMap;
        }
        List<String> sitemapUrls = this.config.properties().linkDiscoveryConfig().sitemapURLs();
        ArrayList<AbstractSiteMap> sitemaps = new ArrayList<AbstractSiteMap>();
        sitemapUrls.forEach(u -> sitemaps.addAll(this.client.getSitemaps((String)u)));
        this.getAllLinks(sitemaps).forEach(link -> this.linkMap.put(link.getUrl(), (SitemapLink)link));
        this.initialized = true;
        return this.linkMap;
    }

    public boolean isUnmodified(String id, long lastEmitted) {
        LocalDateTime lastEmittedDate = SitemapLinks.toLocalDateTiem(lastEmitted);
        SitemapLink link = this.getAllLinks().get(id);
        return link != null && lastEmittedDate.isAfter(link.getLastMod());
    }

    public Set<SitemapLink> getLinks(long lastCrawlTime) {
        LocalDateTime lastCrawlTimeDate = SitemapLinks.toLocalDateTiem(lastCrawlTime);
        return this.getAllLinks().values().stream().filter(l -> l.getLastMod().isAfter(lastCrawlTimeDate)).collect(Collectors.toSet());
    }

    @Nonnull
    private static LocalDateTime toLocalDateTiem(long lastCrawlTime) {
        return LocalDateTime.ofEpochSecond(lastCrawlTime, 0, ZoneOffset.UTC);
    }

    private List<SitemapLink> getLinks(SiteMap siteMap) {
        String sitemapUrl = siteMap.getUrl().toExternalForm();
        return siteMap.getSiteMapUrls().stream().map(l -> new SitemapLink(l.getUrl().toExternalForm(), SitemapLinks.toLocalDateTime(l.getLastModified()), sitemapUrl)).filter(l -> this.linkChecker.isLegalLink(l.getUrl())).collect(Collectors.toList());
    }

    @Nonnull
    private static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return LocalDateTime.MAX;
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    private Set<SitemapLink> getAllLinks(List<AbstractSiteMap> sitemaps) {
        LinkedHashSet<SitemapLink> sitemapLinks = new LinkedHashSet<SitemapLink>();
        for (AbstractSiteMap siteMap : sitemaps) {
            logger.info("Adding all URLs from sitemaps");
            sitemapLinks.addAll(this.getLinks((SiteMap)siteMap));
        }
        return sitemapLinks;
    }

    public boolean hasLink(String link) {
        return this.getAllLinks().values().stream().anyMatch(s -> StringUtils.equals((CharSequence)s.getUrl(), (CharSequence)link));
    }
}

