/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.sitemap;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.http.client.RequestExecutor;
import com.lucidworks.connector.plugins.web.util.HttpClientUtil;
import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMapIndex;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.UnknownFormatException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitemapClient {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SitemapClient.class);
    private final CloseableHttpClient httpClient;
    private final RequestExecutor exec;
    private final Integer timeoutMS;
    private final Boolean infiniteTimeoutMS;
    private final String addedHeaders;
    private final SiteMapParser parser;

    @Inject
    public SitemapClient(WebConfig config, CloseableHttpClient httpClient, RequestExecutor exec) {
        this.exec = exec;
        this.httpClient = httpClient;
        this.infiniteTimeoutMS = config.properties().crawlPerformanceConfig().infiniteTimeout();
        this.timeoutMS = this.infiniteTimeoutMS != false ? 0 : config.properties().crawlPerformanceConfig().timeoutMS();
        this.addedHeaders = config.properties().linkDiscoveryConfig().addedHeaders();
        this.parser = new SiteMapParser(false);
    }

    public List<AbstractSiteMap> getSitemaps(String url) {
        String sitemapURL;
        HashSet<String> visited = new HashSet<String>();
        ArrayList<AbstractSiteMap> sitemaps = new ArrayList<AbstractSiteMap>();
        LinkedList<String> urlsToVisit = new LinkedList<String>();
        urlsToVisit.add(url);
        while ((sitemapURL = (String)urlsToVisit.poll()) != null) {
            AbstractSiteMap sitemap;
            if (visited.contains(sitemapURL)) continue;
            try {
                sitemap = this.requestSitemap(sitemapURL);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebConnectorException(String.format("Could not fetch sitemap: %s", sitemapURL));
            }
            catch (Exception e) {
                throw new WebConnectorException(String.format("Could not fetch sitemap: %s", sitemapURL));
            }
            if (!sitemap.isIndex()) {
                sitemaps.add(sitemap);
                continue;
            }
            Collection sitemapsNew = ((SiteMapIndex)sitemap).getSitemaps();
            List sitemapUrls = sitemapsNew.stream().map(s -> s.getUrl().toExternalForm()).collect(Collectors.toList());
            urlsToVisit.addAll(sitemapUrls);
            visited.add(sitemapURL);
        }
        return sitemaps;
    }

    private AbstractSiteMap requestSitemap(String sitemapURL) throws URISyntaxException, TimeoutException, InterruptedException, ExecutionException, UnknownFormatException, IOException {
        HttpGet req = new HttpGet();
        HttpClientUtil.putAddedHeadersIntoHttpGet(req, this.addedHeaders);
        logger.info("Fetching sitemap: [ {} ]", (Object)sitemapURL);
        req.setURI(new URI(sitemapURL));
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse resp = HttpClientUtil.request((HttpClient)this.httpClient, (HttpUriRequest)req, (HttpContext)context, this.exec.get(), this.timeoutMS, this.infiniteTimeoutMS);
        Map<String, Object> metadata = HttpClientUtil.parseResponseMetadata((HttpUriRequest)req, resp, (HttpContext)context);
        String fetchedID = (String)metadata.get("fetchedID");
        String mimeType = (String)metadata.get("mimeType");
        byte[] entity = HttpClientUtil.readEntity((HttpUriRequest)req, resp, this.exec.get(), this.timeoutMS, this.infiniteTimeoutMS);
        req.releaseConnection();
        return this.parser.parseSiteMap(mimeType, entity, new URL(fetchedID));
    }
}

