/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.script;

import com.lucidworks.connector.plugins.web.fetcher.script.ArgsAndReturnType;
import com.lucidworks.connector.plugins.web.fetcher.script.ScriptRunnerException;
import com.lucidworks.connector.plugins.web.util.LRUCache;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptRunner.class);
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private final ScriptEngineManager manager;
    private ThreadLocal<Invocable> engine;
    private boolean hasCache;
    private int cacheSize;
    private final ConcurrentMap<String, Map> cache = new ConcurrentHashMap<String, Map>();

    public ScriptRunner() {
        this.manager = new ScriptEngineManager();
    }

    public void init(String jsScript) throws ScriptRunnerException {
        this.init(jsScript, 10000);
    }

    public void init(String jsScript, int cacheSize) throws ScriptRunnerException {
        this.cache.clear();
        this.cacheSize = cacheSize;
        this.hasCache = this.cacheSize > 0;
        AtomicReference initError = new AtomicReference();
        this.engine = ThreadLocal.withInitial(() -> this.buildInvocable(jsScript, initError));
        this.engine.get();
        if (null != initError.get()) {
            throw new ScriptRunnerException("Failed to initialize the script engine", (Throwable)initError.get());
        }
    }

    private Invocable buildInvocable(String jsScript, AtomicReference<ScriptException> initError) {
        Invocable inv = null;
        try {
            ScriptEngine jsEngine = this.manager.getEngineByName("js");
            SimpleScriptContext ctx = new SimpleScriptContext();
            ctx.setAttribute("logger", LOG, 100);
            jsEngine.setContext(ctx);
            jsEngine.eval(jsScript);
            inv = (Invocable)((Object)jsEngine);
        }
        catch (ScriptException e) {
            initError.set(e);
        }
        return inv;
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public boolean hasFunction(String function, ArgsAndReturnType a) {
        try {
            this.engine.get().invokeFunction(function, a.getArgs());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runFunction(String f, ArgsAndReturnType<T> a) throws ScriptRunnerException {
        Object t;
        block9: {
            a.validateArgs();
            t = null;
            boolean cacheHit = false;
            try {
                Object o;
                ConcurrentMap<String, Map> m;
                if (this.hasCache && null != (m = (ConcurrentMap<String, Map>)this.cache.get(f)) && null != (o = m.get(a))) {
                    t = a.getReturnType().cast(o);
                    cacheHit = true;
                }
                if (cacheHit) break block9;
                t = a.getReturnType().cast(this.engine.get().invokeFunction(f, a.getArgs()));
                if (!this.hasCache) break block9;
                if (!this.cache.containsKey(f)) {
                    m = this.cache;
                    synchronized (m) {
                        if (!this.cache.containsKey(f)) {
                            this.cache.put(f, Collections.synchronizedMap(new LRUCache(this.cacheSize)));
                        }
                    }
                }
                ((Map)this.cache.get(f)).put(a, t);
            }
            catch (NoSuchMethodException | ScriptException e) {
                throw new ScriptRunnerException("Failed to execute script function '" + f + "()'", e);
            }
            catch (ClassCastException e) {
                throw new ScriptRunnerException("Illegal type returned by script function '" + f + "()', expected " + a.getReturnType().getName(), e);
            }
        }
        return (T)t;
    }
}

