/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.recrawl;

import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.RecrawlRulesConfig;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlRule;
import com.lucidworks.connector.plugins.web.fetcher.script.ArgsAndReturnType;
import com.lucidworks.connector.plugins.web.fetcher.script.ScriptRunner;
import com.lucidworks.connector.plugins.web.fetcher.script.ScriptRunnerException;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;

public class RecrawlScript
implements RecrawlRule {
    public static final String SHOULD_REFRESH_FUNCTION = "shouldRefresh";
    private final ScriptRunner runner;

    public RecrawlScript(RecrawlRulesConfig config, ScriptRunner scriptRunner) {
        try {
            this.runner = scriptRunner;
            this.runner.init(config.refreshScript());
            if (!this.runner.hasFunction(SHOULD_REFRESH_FUNCTION, new ShouldRefreshArgsAndReturnType(new FetchInput.Builder("foo").build()))) {
                throw new WebConnectorException("Missing 'shouldRefresh()' in refresh-policy script or Javascript execution is not allowed.");
            }
        }
        catch (ScriptRunnerException e) {
            throw new WebConnectorException("Failed to initialize the refresh-policy script-runner", e);
        }
    }

    @Override
    public boolean shouldRecrawl(FetchInput ci) {
        try {
            return this.runner.runFunction(SHOULD_REFRESH_FUNCTION, new ShouldRefreshArgsAndReturnType(ci));
        }
        catch (ScriptRunnerException e) {
            throw new WebConnectorException("Could not execute shouldRefresh() function", e);
        }
    }

    private static final class ShouldRefreshArgsAndReturnType
    extends ArgsAndReturnType<Boolean> {
        private final Object[] args;

        private ShouldRefreshArgsAndReturnType(FetchInput ci) {
            this.args = new Object[]{ci.getId(), ci.getMetadata().get("lastModified"), ci.getMetadata().get("lastFetched"), ci.getMetadata().get("lastEmitted"), ci.getMetadata().get("signature"), ci.getMetadata().get("error")};
        }

        @Override
        public Class<Boolean> getReturnType() {
            return Boolean.class;
        }

        @Override
        public Object[] getArgs() {
            return this.args;
        }

        @Override
        public void validateArgs() {
        }
    }
}

