/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.recrawl;

import com.lucidworks.connector.plugins.web.config.RecrawlRulesConfig;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlRule;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RecrawlIdRegexes
implements RecrawlRule {
    private final ThreadLocal<Set<Matcher>> matchers;

    public RecrawlIdRegexes(RecrawlRulesConfig config) {
        Set<String> regexes = config.refreshIDRegexes().stream().map(p -> p.toLowerCase(Locale.US)).collect(Collectors.toSet());
        this.matchers = this.makeThreadLocalMatchers(regexes);
    }

    @Override
    public boolean shouldRecrawl(FetchInput input) {
        return input.hasId() && this.recrawlIDRegex(input.getId());
    }

    private boolean recrawlIDRegex(String id) {
        for (Matcher m : this.matchers.get()) {
            if (!m.reset(id).matches()) continue;
            return true;
        }
        return false;
    }

    private ThreadLocal<Set<Matcher>> makeThreadLocalMatchers(Set<String> regexes) {
        return ThreadLocal.withInitial(() -> {
            LinkedHashSet<Matcher> localMatchers = new LinkedHashSet<Matcher>(regexes.size());
            for (String regex : regexes) {
                localMatchers.add(Pattern.compile(regex, 2).matcher(""));
            }
            return localMatchers;
        });
    }
}

