/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.recrawl;

import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlRule;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecrawlAge
implements RecrawlRule {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(RecrawlAge.class);
    private final long fetchedDateThreshold;

    public RecrawlAge(int olderThanSeconds) {
        this.fetchedDateThreshold = Math.max(0L, System.currentTimeMillis() / 1000L - (long)olderThanSeconds);
        logger.info("Max last-fetched-date to trigger a refresh: {}", (Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(this.fetchedDateThreshold * 1000L), ZoneId.systemDefault()));
    }

    @Override
    public boolean shouldRecrawl(FetchInput input) {
        long lastFetched = input.getMetadata().getOrDefault("lastFetched", 0L);
        return lastFetched <= this.fetchedDateThreshold;
    }
}

