/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.login;

import com.lucidworks.connector.plugins.web.fetcher.http.login.HttpCredential;
import com.lucidworks.connector.plugins.web.fetcher.http.login.WebCookieStore;
import com.lucidworks.connector.plugins.web.util.HttpClientUtil;
import com.lucidworks.connector.plugins.web.util.Utils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormLogins {
    private static final Logger LOG = LoggerFactory.getLogger(FormLogins.class);
    private final boolean diagnosticMode;
    private volatile boolean firstFormLoginDone;
    private ConcurrentMap<HttpCredential, AtomicLong> formLoginCredentials = new ConcurrentHashMap<HttpCredential, AtomicLong>();
    private WebCookieStore cookieStore;

    public FormLogins(HttpCredential[] credentials, WebCookieStore cookieStore, boolean diagnosticMode) {
        for (HttpCredential credential : credentials) {
            if (!credential.getType().equals("form")) continue;
            this.formLoginCredentials.put(credential, new AtomicLong(0L));
        }
        this.diagnosticMode = diagnosticMode;
        this.cookieStore = cookieStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(HttpClient client) throws URISyntaxException {
        for (Map.Entry flcme : this.formLoginCredentials.entrySet()) {
            HttpCredential credential = (HttpCredential)flcme.getKey();
            double ttl = credential.getTTL();
            if (ttl == -1.0 && this.firstFormLoginDone) continue;
            AtomicLong timeOfLastLogin = (AtomicLong)flcme.getValue();
            long timeElapsed = System.currentTimeMillis() - timeOfLastLogin.get();
            if (!(ttl - (double)timeElapsed < 0.1 * ttl)) continue;
            FormLogins formLogins = this;
            synchronized (formLogins) {
                timeElapsed = System.currentTimeMillis() - timeOfLastLogin.get();
                if (ttl - (double)timeElapsed < 0.1 * ttl) {
                    this.doFormLogin(client, credential, timeOfLastLogin, 0);
                }
            }
        }
        this.firstFormLoginDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFormLogin(HttpClient client, HttpCredential credential, AtomicLong timeOfLogin, int nthRetry) throws URISyntaxException {
        Map<String, String> params = credential.getFormParams();
        HttpPost httpPost = new HttpPost(credential.getAction());
        ArrayList<BasicNameValuePair> urlParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> param : params.entrySet()) {
            urlParams.add(new BasicNameValuePair(param.getKey(), param.getValue()));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParams));
            BasicHttpContext context = new BasicHttpContext();
            HttpResponse resp = client.execute((HttpUriRequest)httpPost, (HttpContext)context);
            long latestLoginTTL = Instant.now().toEpochMilli();
            timeOfLogin.set(latestLoginTTL);
            this.cookieStore.setLatestLogin(latestLoginTTL);
            Map<String, Object> respMetadata = HttpClientUtil.parseResponseMetadata((HttpUriRequest)httpPost, resp, (HttpContext)context);
            String charSet = respMetadata.containsKey("charSet") ? (String)respMetadata.get("charSet") : "UTF-8";
            int status = resp.getStatusLine().getStatusCode();
            LOG.info("Executed form login: [ action={} status={} ]", (Object)credential.getAction(), (Object)status);
            if (status >= 400) {
                LOG.warn("Non-OK HTTP-status from form login: {}; raw form response: {}{}", new Object[]{status, Utils.NEWLINE, new String(EntityUtils.toByteArray((HttpEntity)resp.getEntity()), charSet)});
            } else if (this.diagnosticMode) {
                LOG.info("Raw form response: {}{}", (Object)Utils.NEWLINE, (Object)new String(EntityUtils.toByteArray((HttpEntity)resp.getEntity()), charSet));
                Header[] cookies = resp.getHeaders("Set-Cookie");
                if (null != cookies) {
                    for (Header cookie : cookies) {
                        LOG.info("Cookie: {}", (Object)cookie.getValue());
                    }
                }
            }
        }
        catch (IOException e) {
            if (nthRetry == 2) {
                LOG.warn("Attempted form login to {} 3 times and failed, giving up", (Object)credential.getAction(), (Object)e);
                timeOfLogin.set(System.currentTimeMillis());
                return;
            }
            LOG.warn("Failed to execute form login to {}, trying again...", (Object)credential.getAction(), (Object)e);
            httpPost.releaseConnection();
            this.doFormLogin(client, credential, timeOfLogin, ++nthRetry);
        }
        finally {
            httpPost.releaseConnection();
        }
    }
}

