/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.client;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutor {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(RequestExecutor.class);
    private static final AtomicInteger threadCounter = new AtomicInteger(0);
    private final ExecutorService sharedExecutor;

    @Inject
    public RequestExecutor(WebConfig config) {
        logger.info("Creating Request Executor");
        int fetchThreads = config.coreProperties().fetchSettings().numFetchThreads();
        this.sharedExecutor = Executors.newFixedThreadPool(fetchThreads, r -> {
            Thread t = new Thread(r, "webfetcher-helper-" + threadCounter.getAndIncrement());
            t.setDaemon(true);
            return t;
        });
    }

    public ExecutorService get() {
        if (this.sharedExecutor.isShutdown()) {
            throw new IllegalStateException("RequestExecutor has been shut down");
        }
        return this.sharedExecutor;
    }

    public void shutdown() {
        if (this.sharedExecutor.isShutdown()) {
            throw new IllegalStateException("RequestExecutor has been shut down");
        }
        this.sharedExecutor.shutdown();
        try {
            if (!this.sharedExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.sharedExecutor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.sharedExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

