/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.client;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.http.HttpLinkNormalizer;
import com.lucidworks.connector.plugins.web.fetcher.http.RobotsTxt;
import com.lucidworks.connector.plugins.web.fetcher.http.client.LinkChecker;
import com.lucidworks.connector.plugins.web.fetcher.http.client.RequestExecutor;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkValidator {
    private static final Logger logger = LoggerFactory.getLogger(LinkValidator.class);
    private final HttpLinkNormalizer linkNormalizer;
    private final WebConfig config;
    private final LinkChecker linkChecker;
    private final CloseableHttpClient httpClient;
    private final RequestExecutor executor;
    private final RobotsTxt robotsTXT;
    private final Boolean obeyRobots;
    private final Integer timeout;
    private final Boolean infiniteTimeout;

    @Inject
    public LinkValidator(WebConfig config, LinkChecker linkChecker, RobotsTxt robotsTXT, CloseableHttpClient httpClient, RequestExecutor executor) {
        this.config = config;
        this.linkChecker = linkChecker;
        this.httpClient = httpClient;
        this.executor = executor;
        this.robotsTXT = robotsTXT;
        this.linkNormalizer = new HttpLinkNormalizer(config.properties().documentParsingConfig().appendTrailingSlashToLinks(), config.properties().crawlHistoryConfig().discardLinkURLQueries(), config.properties().crawlHistoryConfig().discardLinkURLAnchors());
        this.obeyRobots = config.properties().crawlAuthenticationConfig().obeyRobots();
        this.infiniteTimeout = config.properties().crawlPerformanceConfig().infiniteTimeout();
        this.timeout = this.infiniteTimeout != false ? 0 : config.properties().crawlPerformanceConfig().timeoutMS();
    }

    public String validate(String link, String charSet) {
        String linkText = link;
        try {
            linkText = this.linkNormalizer.normalize(linkText, charSet);
            if (null == linkText) {
                if (this.config.diagnosticLogging().booleanValue()) {
                    logger.info("Link is invalid: {}", (Object)link);
                }
                return null;
            }
            if (!this.linkChecker.isLegalLink(linkText)) {
                if (this.config.diagnosticLogging().booleanValue()) {
                    logger.info("Link is invalid: {}", (Object)link);
                }
                return null;
            }
            if (this.obeyRobots.booleanValue() && !this.robotsTXT.isAllowed(linkText, (HttpClient)this.httpClient, this.executor.get(), this.timeout)) {
                if (this.config.diagnosticLogging().booleanValue()) {
                    logger.info("Link is disallowed by robots.txt: {}", (Object)linkText);
                }
                return null;
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            if (this.config.diagnosticLogging().booleanValue()) {
                logger.info("Link is mal-formatted: {}", (Object)link, (Object)e);
            }
            return null;
        }
        return linkText;
    }
}

