/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.client;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.lucidworks.connector.plugins.web.config.CrawlAuthenticationConfig;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.http.login.CredentialsWrapper;
import com.lucidworks.connector.plugins.web.fetcher.http.login.HttpCredential;
import com.lucidworks.connector.plugins.web.fetcher.http.login.HttpCredentialMapper;
import com.lucidworks.connector.plugins.web.fetcher.http.login.WebCookieStore;
import com.lucidworks.connector.plugins.web.util.HttpClientUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProvider
implements Provider<CloseableHttpClient> {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientProvider.class);
    private static final String COOKIES_BROWSER_COMPAT = "browser-compatibility";
    private static final String COOKIES_STANDARD = "rfc-2965";
    private static final String COOKIES_BEST_MATCH = "best-match";
    private static final String COOKIES_IGNORE = "ignore-all";
    private final WebConfig config;
    private final CredentialsWrapper credentialsWrapper;
    private CloseableHttpClient sharedHttpClient;
    private HttpClientConnectionManager manager;
    private final WebCookieStore basicCookieStore;
    private static final Map<String, String> COOKIE_SPECS = Map.of("browser-compatibility", "standard", "rfc-2965", "standard", "best-match", "standard", "ignore-all", "ignoreCookies");

    @Inject
    public HttpClientProvider(WebConfig config, CredentialsWrapper credentialsWrapper, WebCookieStore basicCookieStore) {
        this.config = config;
        this.credentialsWrapper = credentialsWrapper;
        this.basicCookieStore = basicCookieStore;
        this.basicCookieStore.setAccessibleUrl(HttpClientProvider.getLoginPage(credentialsWrapper.getCredentials()));
    }

    public CloseableHttpClient get() {
        this.initializeClient();
        return this.sharedHttpClient;
    }

    public void shutdown() {
        if (this.sharedHttpClient != null) {
            try {
                this.sharedHttpClient.close();
            }
            catch (Exception e) {
                logger.info("Error while closing the http client.", (Throwable)e);
            }
        }
    }

    private void initializeClient() {
        CrawlAuthenticationConfig authentication = this.config.properties().crawlAuthenticationConfig();
        ArrayList creds = new ArrayList();
        authentication.basicAuth().stream().map(a -> HttpCredentialMapper.mapBasic(a._data())).forEach(creds::add);
        authentication.digestAuth().stream().map(a -> HttpCredentialMapper.mapDigest(a._data())).forEach(creds::add);
        authentication.formAuth().stream().map(a -> HttpCredentialMapper.mapForm(a._data())).forEach(creds::add);
        authentication.samlAuth().stream().map(a -> HttpCredentialMapper.mapSaml(a._data())).forEach(creds::add);
        authentication.ntlmAuth().stream().map(a -> HttpCredentialMapper.mapNtlm(a._data())).forEach(creds::add);
        this.manager = HttpClientUtil.makeConnectionManager(this.config.coreProperties().fetchSettings().numFetchThreads(), this.config.properties().crawlAuthenticationConfig().allowAllCertificates(), this.config.properties().crawlAuthenticationConfig().useIpAddressForSslConnections());
        HttpCredential[] credentials = creds.toArray(new HttpCredential[0]);
        HttpClientBuilder builder = this.getHttpClientBuilder();
        if (this.credentialsWrapper.hasHttpLogins()) {
            builder.setDefaultCredentialsProvider(HttpClientUtil.makeCredentialsProvider(credentials));
        }
        this.sharedHttpClient = builder.build();
    }

    private HttpClientBuilder getHttpClientBuilder() {
        boolean infiniteTimeout = this.config.properties().crawlPerformanceConfig().infiniteTimeout();
        int timeoutMs = this.config.properties().crawlPerformanceConfig().timeoutMS();
        return HttpClientUtil.makeClientBuilder(this.manager, timeoutMs, infiniteTimeout, this.config.properties().crawlPerformanceConfig().requestRetryCount(), this.config.properties().crawlAuthenticationConfig().proxy(), this.config.properties().crawlIdConfig().userAgentName(), COOKIE_SPECS.get(this.config.properties().cookieSpec()), this.basicCookieStore, this.config.properties().linkDiscoveryConfig().allowCircularRedirects());
    }

    public static String getLoginPage(List<HttpCredential> credentials) {
        if (credentials.isEmpty()) {
            return "";
        }
        StringBuilder loginPage = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)credentials.get(0).getLoginLink())) {
            loginPage.append(credentials.get(0).getLoginLink());
        } else if (StringUtils.isNotBlank((CharSequence)credentials.get(0).getAction())) {
            URI uri = URI.create(credentials.get(0).getAction());
            loginPage.append(uri.getScheme()).append("://").append(uri.getAuthority());
        } else {
            loginPage.append(credentials.get(0).getPort() == 443 ? "https://" : "http://").append(credentials.get(0).getHost());
            if (credentials.get(0).getPort() != 80 && credentials.get(0).getPort() != 443) {
                loginPage.append(":").append(credentials.get(0).getPort());
            }
        }
        return loginPage.toString();
    }
}

