/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http;

import com.lucidworks.connector.plugins.web.util.JsoupUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JsoupFilter.class);
    private final Set<String> filteringRootTags = new LinkedHashSet<String>();
    private final Set<String> includeFilters = new LinkedHashSet<String>();
    private final Set<String> excludeFilters = new LinkedHashSet<String>();

    public static String makeFilter(String selector, boolean inclusive) {
        return inclusive ? selector + ", " + selector + " *, :has(" + selector + ")" : selector;
    }

    public void clearAllInclusiveFilters() {
        this.includeFilters.clear();
    }

    public void clearAllExclusiveFilters() {
        this.excludeFilters.clear();
    }

    public void clearAllFilters() {
        this.clearAllInclusiveFilters();
        this.clearAllExclusiveFilters();
    }

    public void addFilteringRootTags(String ... filteringRootTags) {
        if (null != filteringRootTags) {
            Collections.addAll(this.filteringRootTags, filteringRootTags);
        }
    }

    public void setFilteringRootTags(String ... filteringRootTags) {
        this.filteringRootTags.clear();
        this.addFilteringRootTags(filteringRootTags);
    }

    public void addIncludedFilters(String ... includedFilters) {
        if (null != includedFilters) {
            for (String includedFilter : includedFilters) {
                Collections.addAll(this.includeFilters, JsoupFilter.makeFilter(includedFilter, true));
            }
        }
    }

    public void addIncludedTags(String ... includedTags) {
        if (null != includedTags) {
            for (String tag : includedTags) {
                this.includeFilters.add(JsoupFilter.makeFilter(JsoupUtil.makeTag(tag), true));
            }
        }
    }

    public void addIncludedTagClasses(String ... includedTagClasses) {
        if (null != includedTagClasses) {
            for (String tagClass : includedTagClasses) {
                this.includeFilters.add(JsoupFilter.makeFilter(JsoupUtil.makeClassAttr(tagClass), true));
            }
        }
    }

    public void addIncludedTagIDs(String ... includedTagIDs) {
        if (null != includedTagIDs) {
            for (String tagID : includedTagIDs) {
                this.includeFilters.add(JsoupFilter.makeFilter(JsoupUtil.makeIDAttr(tagID), true));
            }
        }
    }

    public void addExcludedFilters(String ... excludedFilters) {
        if (null != excludedFilters) {
            for (String excludedFilter : excludedFilters) {
                Collections.addAll(this.excludeFilters, JsoupFilter.makeFilter(excludedFilter, false));
            }
        }
    }

    public void addExcludedTags(String ... excludedTags) {
        if (null != excludedTags) {
            for (String tag : excludedTags) {
                this.excludeFilters.add(JsoupFilter.makeFilter(JsoupUtil.makeTag(tag), false));
            }
        }
    }

    public void addExcludedTagClasses(String ... excludedTagClasses) {
        if (null != excludedTagClasses) {
            for (String tagClass : excludedTagClasses) {
                this.excludeFilters.add(JsoupFilter.makeFilter(JsoupUtil.makeClassAttr(tagClass), false));
            }
        }
    }

    public void addExcludedTagIDs(String ... excludedTagIDs) {
        if (null != excludedTagIDs) {
            for (String tagID : excludedTagIDs) {
                this.excludeFilters.add(JsoupFilter.makeFilter(JsoupUtil.makeIDAttr(tagID), false));
            }
        }
    }

    public void filter(Document doc) {
        for (String filteringRootTag : this.filteringRootTags) {
            Elements rootElements = doc.getElementsByTag(filteringRootTag);
            if (null == rootElements || rootElements.size() <= 0) continue;
            for (Element rootElement : rootElements) {
                Elements childElementsToRemove;
                Elements childElements;
                if (this.includeFilters.size() > 0 && null != (childElements = rootElement.children()) && childElements.size() > 0) {
                    childElementsToRemove = childElements;
                    for (String selector : this.includeFilters) {
                        if (0 == childElementsToRemove.size()) break;
                        Elements childElementsToRetain = childElementsToRemove.select(selector);
                        for (Element childElementToRetain : childElementsToRetain) {
                            childElementsToRemove.remove((Object)childElementToRetain);
                        }
                    }
                    for (Element childElementToRemove : childElementsToRemove) {
                        if (null == childElementToRemove.ownerDocument()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Removing non-included element: {}", (Object)childElementToRemove.toString());
                        }
                        childElementToRemove.remove();
                    }
                }
                if (this.excludeFilters.size() <= 0 || null == (childElements = rootElement.children()) || childElements.size() <= 0) continue;
                for (String selector : this.excludeFilters) {
                    childElementsToRemove = childElements.select(selector);
                    for (Element childElementToRemove : childElementsToRemove) {
                        if (null == childElementToRemove.ownerDocument()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Removing excluded element: {}", (Object)childElementToRemove.toString());
                        }
                        childElementToRemove.remove();
                    }
                }
            }
        }
    }
}

