/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.script.ArgsAndReturnType;
import com.lucidworks.connector.plugins.web.fetcher.script.DefaultScriptRunnerProvider;
import com.lucidworks.connector.plugins.web.fetcher.script.ScriptRunner;
import com.lucidworks.connector.plugins.web.fetcher.script.ScriptRunnerException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkRewriter {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(LinkRewriter.class);
    private static final String REWRITE_LINK_FUNCTION = "rewriteLink";
    private final ScriptRunner rewriter;

    @Inject
    public LinkRewriter(WebConfig config) {
        this(config.properties().rewriteLinkScript(), new DefaultScriptRunnerProvider().get());
    }

    public LinkRewriter(String script, ScriptRunner scriptRunner) {
        if (StringUtils.isBlank((CharSequence)script)) {
            this.rewriter = null;
            return;
        }
        try {
            this.rewriter = scriptRunner;
            this.rewriter.init(script);
            if (!this.rewriter.hasFunction(REWRITE_LINK_FUNCTION, new RewriteLinkArgsAndReturnType("link"))) {
                throw new WebConnectorException("Missing 'rewriteLink()' in link-rewriting script or Javascript execution is not allowed.");
            }
        }
        catch (ScriptRunnerException e) {
            throw new WebConnectorException("Failed to initialize the link-rewriter script-runner", e);
        }
    }

    public String rewriteLink(String link) {
        if (this.rewriter == null) {
            return link;
        }
        Object e = null;
        String rewrittenLink = link;
        try {
            rewrittenLink = this.rewriter.runFunction(REWRITE_LINK_FUNCTION, new RewriteLinkArgsAndReturnType(link));
        }
        catch (ScriptRunnerException ex) {
            logger.warn("Failed to rewrite link: '{}', using the original", (Object)link, e);
            return rewrittenLink;
        }
        logger.info("Rewrote link: '{}' -> '{}'", (Object)link, (Object)rewrittenLink);
        return rewrittenLink;
    }

    private static final class RewriteLinkArgsAndReturnType
    extends ArgsAndReturnType<String> {
        private String link;

        private RewriteLinkArgsAndReturnType(String link) {
            this.link = link;
        }

        @Override
        public Class<String> getReturnType() {
            return String.class;
        }

        @Override
        public Object[] getArgs() {
            return new String[]{this.link};
        }

        @Override
        public void validateArgs() throws ScriptRunnerException {
            if (null == this.link) {
                throw new ScriptRunnerException("Invalid script argument: link is null");
            }
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

