/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.config.CrawlPerformanceConfig;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchDelay {
    private static final Logger LOG = LoggerFactory.getLogger(FetchDelay.class);
    private final CrawlPerformanceConfig config;
    private final ConcurrentMap<String, DelayQueue<DelayedFetch>> delayQueueMap = new ConcurrentHashMap<String, DelayQueue<DelayedFetch>>();

    @Inject
    public FetchDelay(WebConfig config) {
        this.config = config.properties().crawlPerformanceConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayFetch(String id) {
        DelayQueue<DelayedFetch> delayQueue;
        if (this.config.fetchDelayMS() <= 0) {
            return;
        }
        String host = "";
        if (this.config.fetchDelayMSPerHost().booleanValue()) {
            try {
                host = new URI(id).getHost();
            }
            catch (URISyntaxException e) {
                LOG.info("Failed to parse host in order to apply fetch delay logic, invalid URI: '{}'", (Object)id, (Object)e);
            }
        }
        if (null == (delayQueue = (DelayQueue<DelayedFetch>)this.delayQueueMap.get(host))) {
            ConcurrentMap<String, DelayQueue<DelayedFetch>> concurrentMap = this.delayQueueMap;
            synchronized (concurrentMap) {
                delayQueue = (DelayQueue)this.delayQueueMap.get(host);
                if (null == delayQueue) {
                    delayQueue = new DelayQueue<DelayedFetch>();
                    this.delayQueueMap.put(host, delayQueue);
                    delayQueue.add(new DelayedFetch(0L));
                }
            }
        }
        Utils.dequeue(delayQueue);
        delayQueue.add(new DelayedFetch(this.config.fetchDelayMS().intValue()));
    }

    private static class DelayedFetch
    implements Delayed {
        private final long start;

        public DelayedFetch(long delay) {
            this.start = System.currentTimeMillis() + delay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.start - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.start, ((DelayedFetch)o).start);
        }
    }
}

