/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Candidate;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.ContentFetcher;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateEmitter {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(CandidateEmitter.class);
    private static final String DEPTH = "depth";
    public static final String PARENT = "parent";
    public final int maxDepth;

    @Inject
    public CandidateEmitter(WebConfig config) {
        this.maxDepth = config.properties().limitDocumentsConfig().depth();
    }

    public void emitCandidate(ContentFetcher.FetchContext context, String id) {
        if (!context.getFetchInput().getMetadata().containsKey(DEPTH)) {
            this.emitInitialCandidate(context, id);
            return;
        }
        long depth = (Long)context.getFetchInput().getMetadata().get(DEPTH);
        long nextDepth = depth + 1L;
        if (this.isLegalDepth(nextDepth)) {
            logger.info("Emitting link candidate {}", (Object)id);
            String parent = context.getFetchInput().getId();
            ((Candidate.Emitter)context.newCandidate(id).metadata(m -> m.merge(Map.of(DEPTH, nextDepth, PARENT, parent)))).emit();
        } else {
            logger.info("Candidate {} ignored as maximum depth of {} has been reached", (Object)id, (Object)this.maxDepth);
        }
    }

    private void emitInitialCandidate(ContentFetcher.FetchContext context, String id) {
        logger.info("Emitting initial candidate {}", (Object)id);
        ((Candidate.Emitter)context.newCandidate(id).metadata(m -> m.merge(Map.of(DEPTH, 0L)))).emit();
    }

    private boolean isLegalDepth(long depth) {
        return this.maxDepth < 0 || depth <= (long)this.maxDepth;
    }

    public void emitSitemapCandidate(ContentFetcher.FetchContext context, String id, String parent) {
        logger.info("Emitting sitemap candidate {}", (Object)id);
        ((Candidate.Emitter)context.newCandidate(id).metadata(m -> m.merge(Map.of(DEPTH, 0L, "_is_sitemap_url", true, PARENT, parent)))).emit();
    }
}

