/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.connector.plugins.web.config.CrawlAuthenticationConfig;
import com.lucidworks.connector.plugins.web.config.CrawlHistoryConfig;
import com.lucidworks.connector.plugins.web.config.CrawlIdConfig;
import com.lucidworks.connector.plugins.web.config.CrawlPerformanceConfig;
import com.lucidworks.connector.plugins.web.config.DedupeConfig;
import com.lucidworks.connector.plugins.web.config.DocumentParsingConfig;
import com.lucidworks.connector.plugins.web.config.JavascriptEvaluationConfig;
import com.lucidworks.connector.plugins.web.config.LimitDocumentsConfig;
import com.lucidworks.connector.plugins.web.config.LinkDiscoveryConfig;
import com.lucidworks.connector.plugins.web.config.RecrawlRulesConfig;
import com.lucidworks.fusion.connector.plugin.api.config.ConnectorConfig;
import com.lucidworks.fusion.connector.plugin.api.config.ConnectorPluginProperties;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

@SchemaAnnotations.RootSchema(title="Web (v2)", description="Connector for websites and web-based content resources.", category="Web")
public interface WebConfig
extends ConnectorConfig<Properties> {
    @SchemaAnnotations.Property(title="Properties", required=true)
    public Properties properties();

    public static interface Properties
    extends ConnectorPluginProperties {
        @SchemaAnnotations.Property(title="Start Links", description="The URL(s) that the crawler will start crawling from, for example: https://en.wikipedia.org/wiki/Main_Page", order=1)
        @SchemaAnnotations.ArraySchema
        @SchemaAnnotations.StringSchema
        public List<String> startLinks();

        @SchemaAnnotations.Property(title="Bulk start links", description="If a large number of start links must be defined, you can provide them here. One link per line.", order=2, hints={"lengthy"})
        @SchemaAnnotations.StringSchema
        public String bulkStartLinks();

        @SchemaAnnotations.Property(title="Limit Documents Properties", description="", order=5)
        public LimitDocumentsConfig limitDocumentsConfig();

        @SchemaAnnotations.Property(title="Crawl Authentication Properties", description="", order=6)
        public CrawlAuthenticationConfig crawlAuthenticationConfig();

        @SchemaAnnotations.Property(title="Crawl History Properties", description="", order=7, hints={"advanced"})
        public CrawlHistoryConfig crawlHistoryConfig();

        @SchemaAnnotations.Property(title="Crawl Id Properties", description="", order=8, hints={"advanced"})
        public CrawlIdConfig crawlIdConfig();

        @SchemaAnnotations.Property(title="Crawl Performance Properties", description="", order=9)
        public CrawlPerformanceConfig crawlPerformanceConfig();

        @SchemaAnnotations.Property(title="Dedupe Properties", description="", order=10, hints={"advanced"})
        public DedupeConfig dedupeConfig();

        @SchemaAnnotations.Property(title="Document Parsing Properties", description="", order=11)
        public DocumentParsingConfig documentParsingConfig();

        @SchemaAnnotations.Property(title="Javascript Evaluation Properties", description="", order=12)
        public JavascriptEvaluationConfig javascriptEvaluationConfig();

        @SchemaAnnotations.Property(title="Link Discovery", description="", order=13)
        public LinkDiscoveryConfig linkDiscoveryConfig();

        @SchemaAnnotations.Property(title="Recrawl Rules", description="", order=14, hints={"advanced"})
        public RecrawlRulesConfig recrawlRulesConfig();

        @SchemaAnnotations.Property(title="Cookie spec", description="", order=15)
        @SchemaAnnotations.StringSchema(defaultValue="browser-compatibility")
        public String cookieSpec();

        @SchemaAnnotations.Property(title="URI rewrite script", description="A Javascript function 'rewriteLink(link) { }' to modify links to documents before they are fetched.", order=16, hints={"advanced", "code", "javascript"})
        @SchemaAnnotations.StringSchema
        public String rewriteLinkScript();
    }
}

