/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

public interface RecrawlRulesConfig
extends Model {
    @SchemaAnnotations.Property(title="Delete dead URIs", description="Set to true to remove documents from the index when they can no longer be accessed as unique documents.", order=1, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean delete();

    @SchemaAnnotations.Property(title="Fetch failure allowance", description="Number of times a website can error out, for example with a 500 error or a connection timeout, before a document is removed from the index. The default of -1 means such documents are never removed. Note that pages that return a 404 status code can be configured to be removed immediately regardless of this setting.", order=2, hints={"advanced"})
    @SchemaAnnotations.NumberSchema(defaultValue=-1.0)
    public Integer deleteErrorsAfter();

    @SchemaAnnotations.Property(title="Recrawl all items", description="Set to true to always recrawl all items found in the crawldb.", order=3, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean refreshAll();

    @SchemaAnnotations.Property(title="Recrawl start links", description="Set to true to recrawl items specified in the list of start links.", order=4, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean refreshStartLinks();

    @SchemaAnnotations.Property(title="Recrawl errors", description="Set to true to recrawl items that failed during the last crawl.", order=5, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean refreshErrors();

    @SchemaAnnotations.Property(title="Recrawl age", description="Number of seconds to recrawl items whose last fetched date is longer ago than this value.", order=6, hints={"advanced"})
    @SchemaAnnotations.NumberSchema(defaultValue=-1.0)
    public Integer refreshOlderThan();

    @SchemaAnnotations.Property(title="Recrawl ID prefixes", description="A prefix to recrawl all items whose IDs begin with this value.", order=7, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> refreshIDPrefixes();

    @SchemaAnnotations.Property(title="Recrawl ID regexes", description="A regular expression to recrawl all items whose IDs match this pattern.", order=8, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> refreshIDRegexes();

    @SchemaAnnotations.Property(title="Recrawl script", description="A JavaScript function ('shouldRefresh()') to customize the items re-crawled. Example: function shouldRefresh(id, lastModified, lastFetched, lastEmitted, signature, error) {return true;} ", order=9, hints={"advanced", "code", "javascript"})
    @SchemaAnnotations.StringSchema
    public String refreshScript();

    @SchemaAnnotations.Property(title="Force recrawl", description="Set to true to recrawl all items even if they have not changed since the last crawl.", order=10, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean forceRefresh();

    @SchemaAnnotations.Property(title="Clear signatures", description="If true, signatures will be cleared if force recrawl is enabled.", order=11, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean forceRefreshClearSignatures();

    @SchemaAnnotations.Property(title="Remove 404/410 pages", description="Select this option to delete indexed pages that return a 404 or 410 error.", order=12, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean delete404();

    @SchemaAnnotations.Property(title="Process Sitemap URLs", description="When enabled, only URLs found in the sitemap will be processed and crawled.", order=13, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean sitemapIncrementalCrawling();
}

