/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

public interface LinkDiscoveryConfig
extends Model {
    @SchemaAnnotations.Property(title="Restrict crawl host prefix exemptions", description="Modifies the behavior of 'Restrict crawl to start-link tree' to ignore the configured list of prefixes when restricting the crawl. Commonly, 'www.' is ignored so links with the same domain are allowed, whether of the form 'http://host.com' or 'http://www.host.com'. This option requires 'Restrict to start-link tree' to be enabled to have any effect.", order=1)
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> restrictToTreeIgnoredHostPrefixes();

    @SchemaAnnotations.Property(title="Restrict crawl to start-link tree", description="If true, only URLs that match the startLinks URL domain will be followed", order=2)
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean restrictToTree();

    @SchemaAnnotations.Property(title="Ignore sub-domains when restricting crawl", description="Modifies the behavior of 'Restrict crawl to start-link tree' so that a link to any sub-domain of the start links is allowed. For example, if the start link is 'http://host.com', this option ensures that links to 'http://news.host.com' are also followed. This option requires 'Restrict to start-link tree' to be enabled to have any effect.", order=3)
    @SchemaAnnotations.BooleanSchema
    public Boolean restrictToTreeAllowSubdomains();

    @SchemaAnnotations.Property(title="Restrict crawl to start-link path", description="Modifies the behavior of 'Restrict crawl to start-link tree' to include the 'path' of the start link in the restriction logic. For example, if the start link is 'http://host.com/US', this option will limit all followed URLs to ones starting with the '/US/' path. This option requires 'Restrict to start-link tree' to be enabled to have any effect.", order=4)
    @SchemaAnnotations.BooleanSchema
    public Boolean restrictToTreeUseHostAndPath();

    @SchemaAnnotations.Property(title="Sitemap URLs", description="URLs for sitemaps, to be used a basis for link discovery. Rules found in sitemaps will not be processed.", order=5)
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> sitemapURLs();

    @SchemaAnnotations.Property(title="Respect refresh redirects", description="If true, the connector will follow metatags with refresh redirects such as <meta http-equiv=\"refresh\" />.", order=7)
    @SchemaAnnotations.BooleanSchema
    public Boolean respectMetaEquivRedirects();

    @SchemaAnnotations.Property(title="Allow circular redirects", description="If true, a request can be redirected to the same URL multiple times", order=8)
    @SchemaAnnotations.BooleanSchema
    public Boolean allowCircularRedirects();

    @SchemaAnnotations.Property(title="Headers to add to HTTP requests", description="Add these headers to http requests. This is useful for web sites that require certain headers to let you visit them. Write each header on its own line in the format HeaderName: HeaderValue", order=9, hints={"lengthy"})
    @SchemaAnnotations.StringSchema
    public String addedHeaders();
}

