/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;

public interface JavascriptEvaluationConfig
extends Model {
    @SchemaAnnotations.Property(title="Evaluate Javascript", description="Evaluate JavaScript on web pages when crawling. This makes it possible for the Web fetcher to extract content from pages that is only available after JavaScript has prepared the document, but it may make the crawl slower because JavaScript loading can be time consuming.", order=1)
    @SchemaAnnotations.BooleanSchema
    public Boolean crawlJS();

    @SchemaAnnotations.Property(title="Evaluate JavaScript during SmartForms/SAML Login", description="Evaluate JavaScript when doing SAML/SmartForm authentication. This is only applicable if you have specified a SmartForms/SAML Authentication element in the \"Crawl Authentication\" area.", order=2)
    @SchemaAnnotations.BooleanSchema
    public Boolean jsEnabledAuth();

    @SchemaAnnotations.Property(title="Timeout", description="The time to wait in milliseconds for a page load to complete. If the timeout is -1, page loads can be indefinite. Maximum: 180,000ms i.e. 3 minutes", order=3)
    @SchemaAnnotations.NumberSchema(defaultValue=15000.0)
    public Integer jsPageLoadTimeout();

    @SchemaAnnotations.Property(title="Script Timeout", description="The time to wait in milliseconds for JavaScript code execution to complete. Controls how long the connector waits for complex scripts to finish running. Suggested timeouts: Standard / Basic websites (30000ms), Complex JS applications / SPA (60000ms), Very slow and Legacy sites (up to 180000ms), Fast/simple sites (15000ms)", order=4)
    @SchemaAnnotations.NumberSchema(defaultValue=30000.0)
    public Integer jsScriptTimeout();

    @SchemaAnnotations.Property(title="Implicit Wait Timeout", description="The time to wait in milliseconds for web elements to become available. This timeout is used when searching for elements on the page. For customers with slow-loading JavaScript content, consider increasing from the default.", order=5)
    @SchemaAnnotations.NumberSchema(defaultValue=5000.0)
    public Integer jsImplicitWaitTimeout();

    @SchemaAnnotations.Property(title="AJAX Timeout", description="The time in milliseconds after which an AJAX request will be ignored when considering whether all AJAX requests have completed. Maximum: 180,000ms i.e. 3 minutes", order=6)
    @SchemaAnnotations.NumberSchema(defaultValue=20000.0)
    public Integer jsAjaxTimeout();

    @SchemaAnnotations.Property(title="Extra time to wait for content after page load (ms)", description="The JavaScript evaluation process will first wait for the DOM 'document.readyState' to be set to 'complete'; then it will wait until there are no more pending Ajax before emitting the page\u2019s contents. Use this property to wait an additional number of milliseconds before emitting the contents. This gives background JavaScript routines a chance to finish rendering the page before the contents is emitted.", order=7, hints={"hidden"})
    @SchemaAnnotations.NumberSchema(defaultValue=250.0)
    public Integer extraLoadTimeMs();

    @SchemaAnnotations.Property(title="Stop waiting for extraLoadTimeMs if page size increases by this many bytes.", description="This parameter is used when the \"Extra time to wait for content after page load (ms)\" parameter is > 0. It will stop the additional wait time if it sees the web page's content grows by at least this many characters. If set to 0 (the default) any increase in character count indicates the page load is finished.", order=8, hints={"hidden"})
    @SchemaAnnotations.NumberSchema(defaultValue=0.0)
    public Integer extraPageLoadDeltaChars();

    @SchemaAnnotations.Property(title="Web Driver Quit Timeout (milliseconds)", description="The amount of time to wait for a web browser to quit before killing the browser process.", order=9, hints={"hidden"})
    @SchemaAnnotations.NumberSchema(defaultValue=5000.0)
    public Integer quitTimeoutMs();

    @SchemaAnnotations.Property(title="Use Request Counter", description="Use the request counter plugin to wait for all pending ajax requests to be complete before loading the page contents.", order=10, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean useRequestCounter();

    @SchemaAnnotations.Property(title="Wait for late AJAX requests", description="Wait for late AJAX requests to be completed before loading the page contents.", order=11)
    @SchemaAnnotations.BooleanSchema(defaultValue=false)
    public Boolean waitForLateAjaxRequests();

    @SchemaAnnotations.Property(title="Request counter min wait (ms)", description="When the requestcounter is enabled, often early on the requestcount may say there are 0 pending requests... but there may still be ajax requests that haven't run yet. This parameter provides a certain time in milliseconds to wait for a non-zero count to be returned. If a requestcount is non-zero at any point, then the next requestcount = 0 is assumed to signify this page is done loading.", order=12)
    @SchemaAnnotations.NumberSchema(defaultValue=500.0)
    public Integer requestCounterMinWaitMs();

    @SchemaAnnotations.Property(title="Request counter max wait (ms)", description="The request counter plugin counts active ajax requests after a page was loaded until there are no more pending ajax requests. This parameter says how long to wait in milliseconds for the requestcount to go to 0 before giving up.", order=13)
    @SchemaAnnotations.NumberSchema(defaultValue=3000.0)
    public Integer requestCounterMaxWaitMs();

    @SchemaAnnotations.Property(title="High Performance Mode", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=14, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema
    public Boolean useHighPerfJsEval();

    @SchemaAnnotations.Property(title="Headless Browser", description="Applicable only when \"Evaluate JavaScript\"  is selected, deselect this checkbox if you want to actually see browser windows display while fetchers process web pages. Otherwise, if selected, browsers will run in \"headless\" mode which means they will run in the background. If running on a server with no desktop interface, this must stay selected.", order=15)
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean headlessBrowser();

    @SchemaAnnotations.Property(title="Index a screenshot of rendered page", description="Applicable only when \"Evaluate JavaScript\"  is selected, take a screenshot of the fully rendered page and index it. Screenshots will be indexed in a field called \"screenshot_bin\". You must make sure your schema specifies this field as a binary field or indexing will fail. To add this, go to System -> Solr Config -> Managed Schema then add <dynamicField indexed=\"true\" name=\"*_bin\" stored=\"true\" type=\"binary\"/>", order=16, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema
    public Boolean takeScreenshot();

    @SchemaAnnotations.Property(title="Screenshots Full Screen", description="When taking a screenshot, capture the full screen.", order=17, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema
    public Boolean screenshotFullscreen();

    @SchemaAnnotations.Property(title="Viewport Width", description="Set an optional browser viewport width. If not specified, will default to 800.", order=18)
    @SchemaAnnotations.NumberSchema(defaultValue=800.0)
    public Integer viewportWidth();

    @SchemaAnnotations.Property(title="Viewport Height", description="Set an optional browser viewport height. If not specified, will default to 600.", order=19)
    @SchemaAnnotations.NumberSchema(defaultValue=600.0)
    public Integer viewportHeight();

    @SchemaAnnotations.Property(title="Device Screen Factor", description="Set an optional browser device screen factor.  If not specified, will default to 1 (no scaling).", order=20)
    @SchemaAnnotations.NumberSchema(defaultValue=1.0)
    public Integer deviceScreenFactor();

    @SchemaAnnotations.Property(title="Simulate mobile", description="Simulate a mobile device", order=21, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema
    public Boolean simulateMobile();

    @SchemaAnnotations.Property(title="Mobile screen width (Only used for simulate mobile)", description="If simulate mobile is checked, this species the device's emulated screen width.", order=22, hints={"hidden"})
    @SchemaAnnotations.NumberSchema
    public Integer mobileScreenWidth();

    @SchemaAnnotations.Property(title="Mobile screen height (Only used for simulate mobile)", description="If simulate mobile is checked, this species the device's emulated screen height.", order=23, hints={"hidden"})
    @SchemaAnnotations.NumberSchema
    public Integer mobileScreenHeight();

    @SchemaAnnotations.Property(title="chromeBinaryPath", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=24, hints={"hidden"})
    @SchemaAnnotations.StringSchema
    public String chromeBinaryPath();

    @SchemaAnnotations.Property(title="Google Chrome Extra Command Line Options", description="Specify additional command line arguments to add to the chromium executable when it is run.", order=25, hints={"advanced"})
    @SchemaAnnotations.StringSchema(defaultValue="")
    public String chromeExtraCommandLineArgs();
}

