/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

public interface FormAuthConfig
extends Model {
    public static final String URL_TITLE = "URL";
    public static final String URL_DESC = "The URL of the authentication endpoint";
    public static final String PARAMS_TITLE = "Parameters";
    public static final String PARAMS_DESC = "Parameters sent to the authentication endpoint";
    public static final String PASSWORD_PARAM_NAME_TITLE = "Password Parameter";
    public static final String PASSWORD_PARAM_NAME_DESC = "Name of the parameter containing the password";
    public static final String PASSWORD_TITLE = "Password";
    public static final String PASSWORD_DESC = "The password to use for the authentication request. This will be copied into the \"Parameters\" using the \"Password Parameter\" name as the key";
    public static final String TTL_TITLE = "TTL (ms)";
    public static final String TTL_DESC = "The \"time to live\" in milliseconds for the session that will be created after authentication.";

    @SchemaAnnotations.Property(title="URL", description="The URL of the authentication endpoint", order=1)
    @SchemaAnnotations.StringSchema
    public String action();

    @SchemaAnnotations.Property(title="TTL (ms)", description="The \"time to live\" in milliseconds for the session that will be created after authentication.", order=2)
    @SchemaAnnotations.NumberSchema(defaultValue=300000.0)
    public Integer ttl();

    @SchemaAnnotations.Property(title="Password Parameter", description="Name of the parameter containing the password", order=3)
    @SchemaAnnotations.StringSchema
    public String passwordParamName();

    @SchemaAnnotations.Property(title="Password", description="The password to use for the authentication request. This will be copied into the \"Parameters\" using the \"Password Parameter\" name as the key", order=4, hints={"secret"})
    @SchemaAnnotations.StringSchema
    public String password();

    @SchemaAnnotations.Property(title="Parameters", description="Parameters sent to the authentication endpoint", order=5)
    @SchemaAnnotations.ArraySchema
    public List<Params> paramsList();

    public static interface Params
    extends Model {
        @SchemaAnnotations.Property(title="Parameters Key", order=11)
        @SchemaAnnotations.StringSchema
        public String key();

        @SchemaAnnotations.Property(title="Parameters value", order=12)
        @SchemaAnnotations.StringSchema
        public String value();
    }
}

