/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;

public interface DedupeConfig
extends Model {
    @SchemaAnnotations.Property(title="Dedupe documents", description="If true, documents will be deduplicated. Deduplication can be done based on an analysis of the content, on the content of a specific field, or by a JavaScript function. If neither a field nor a script are defined, content analysis will be used.", order=1, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema
    public Boolean dedupe();

    @SchemaAnnotations.Property(title="Dedupe field", description="Field to be used for dedupe. Define either a field or a dedupe script, otherwise the full raw content of each document will be used.", order=2, hints={"hidden"})
    @SchemaAnnotations.StringSchema
    public String dedupeField();

    @SchemaAnnotations.Property(title="Dedupe script", description="Custom javascript to dedupe documents. The script must define a 'genSignature(content){}' function, but can use any combination of document fields. The function must return a string.", order=3, hints={"hidden", "code", "javascript"})
    @SchemaAnnotations.StringSchema
    public String dedupeScript();

    @SchemaAnnotations.Property(title="Save dedupe signature", description="If true,the signature used for dedupe will be stored in a 'dedupeSignature_s' field. Note this may cause errors about 'immense terms' in that field.", order=4, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema
    public Boolean dedupeSaveSignature();

    @SchemaAnnotations.Property(title="Deduplication via canonical tag", description="Deduplicate, by only indexing the document at the URL specified in the canonical tag. https://en.wikipedia.org/wiki/Canonical_link_element", order=5, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean followCanonicalTags();

    @SchemaAnnotations.Property(title="The maximum number of requests to perform while resolving the canonical URL for a page.", description="Because canonical tag resolution may be cyclical, a limit must be applied to the total number of requests. This value ensures that the resolution finishes in a reasonable amount of time.", order=6, hints={"advanced"})
    @SchemaAnnotations.NumberSchema(defaultValue=4.0)
    public Integer canonicalTagsRedirectLimit();
}

