/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;

public interface CrawlPerformanceConfig
extends Model {
    @SchemaAnnotations.Property(title="Fetch delay per host", description="If true, the 'Fetch delay (ms)' property will be applied for each host.", order=1, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean fetchDelayMSPerHost();

    @SchemaAnnotations.Property(title="Fetch threads", description="The number of threads to use during fetching. The default is 5.", order=2, hints={"hidden"})
    @SchemaAnnotations.NumberSchema(defaultValue=5.0)
    public Integer fetchThreads();

    @SchemaAnnotations.Property(title="Emit threads", description="The number of threads used to send documents from the connector to the index pipeline. The default is 5.", order=3)
    @SchemaAnnotations.NumberSchema(defaultValue=5.0)
    public Integer emitThreads();

    @SchemaAnnotations.Property(title="Fetch batch size", description="The number of items to batch for each round of fetching. A higher value can make crawling faster, but memory usage is also increased. The default is 1.", order=4, hints={"advanced"})
    @SchemaAnnotations.NumberSchema(defaultValue=1.0)
    public Integer chunkSize();

    @SchemaAnnotations.Property(title="Fetch delay", description="Number of milliseconds to wait between fetch requests. The default is 0. This property can be used to throttle a crawl if necessary.", order=5, hints={"advanced"})
    @SchemaAnnotations.NumberSchema(defaultValue=0.0)
    public Integer fetchDelayMS();

    @SchemaAnnotations.Property(title="Retry emits", description="Set to true for emit batch failures to be retried on a document-by-document basis.", order=6, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean retryEmit();

    @SchemaAnnotations.Property(title="Fail crawl if start links are invalid", description="If true, when Fusion cannot connect to any of the provided start links, the crawl is stopped and an exception logged.", order=7, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean failFastOnStartLinkFailure();

    @SchemaAnnotations.Property(title="Request Retry Count", description="If an http request fails, retry up to this many times before giving up. If set to 0, requests will not be retried. This is useful in situations where your crawls are failing with errors like \"The target server failed to respond\".", order=8)
    @SchemaAnnotations.NumberSchema(defaultValue=0.0)
    public Integer requestRetryCount();

    @SchemaAnnotations.Property(title="Obey robots.txt Crawl-Delay", description="If true, Crawl-Delay rules in robots.txt will be obeyed. Disabling this option will speed up crawling, but is considered negative behavior for sites you do not control.", order=9, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean obeyRobotsDelay();

    @SchemaAnnotations.Property(title="Max Parser Retries", description="The maximum number of times the configured parser will try getting content before giving up", order=10, hints={"hidden"})
    @SchemaAnnotations.NumberSchema(defaultValue=0.0)
    public Integer parserRetryCount();

    @SchemaAnnotations.Property(title="Connection timeout (ms)", description="Time in milliseconds to wait for server response. This setting is only used when 'Use infinite timeout' is disabled.", order=11, hints={"advanced"})
    @SchemaAnnotations.NumberSchema(defaultValue=10000.0)
    public Integer timeoutMS();

    @SchemaAnnotations.Property(title="Enable Infinite timeout", description="When unchecked infinite timeout is disabled. if the property is checked the timeoutMS value is ignored", order=12, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema(defaultValue=false)
    public Boolean infiniteTimeout();
}

