/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.connector.plugins.web.config.AccessTokenConfig;
import com.lucidworks.connector.plugins.web.config.BasicAuthConfig;
import com.lucidworks.connector.plugins.web.config.DigestAuthConfig;
import com.lucidworks.connector.plugins.web.config.FormAuthConfig;
import com.lucidworks.connector.plugins.web.config.NtlmAuthConfig;
import com.lucidworks.connector.plugins.web.config.SamlAuthConfig;
import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

public interface CrawlAuthenticationConfig
extends Model {
    @SchemaAnnotations.Property(title="Maintain Cookies for No-Auth Crawls", description="If you are not using authentication, then by default cookies are not stored in between web requests (stateless). If checked, cookies will be maintained between requests during the web crawl even when you are not using authentication. If you are using authentication, this checkbox has no effect on the crawl and can be ignored.", order=1, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean maintainCookies();

    @SchemaAnnotations.Property(title="Basic Authentication", description="Settings for Basic authentication", order=2)
    @SchemaAnnotations.ArraySchema
    public List<BasicAuthConfig> basicAuth();

    @SchemaAnnotations.Property(title="Digest Authentication", description="Settings for Digest authentication", order=3)
    @SchemaAnnotations.ArraySchema
    public List<DigestAuthConfig> digestAuth();

    @SchemaAnnotations.Property(title="NTLM Authentication", description="Settings for NTLM authentication", order=4)
    @SchemaAnnotations.ArraySchema
    public List<NtlmAuthConfig> ntlmAuth();

    @SchemaAnnotations.Property(title="Form Authentication", description="Settings for Form based authentication", order=5)
    @SchemaAnnotations.ArraySchema
    public List<FormAuthConfig> formAuth();

    @SchemaAnnotations.Property(title="SAML/Smart Form Authentication", description="Settings for SAML/Smart Form based authentication allows you to visit one or more web pages that contain form inputs such as username, password, security questions, etc., submitting each one in turn in order to become authenticated.", order=6)
    @SchemaAnnotations.ArraySchema
    public List<SamlAuthConfig> samlAuth();

    @SchemaAnnotations.Property(title="credentialsFile", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=7)
    @SchemaAnnotations.StringSchema
    public String credentialsFile();

    @SchemaAnnotations.Property(title="kerberosEnabled", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=8)
    @SchemaAnnotations.BooleanSchema
    public Boolean kerberosEnabled();

    @SchemaAnnotations.Property(title="kerberosLoginContextName", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=9)
    @SchemaAnnotations.StringSchema
    public String kerberosLoginContextName();

    @SchemaAnnotations.Property(title="kerberosSpn", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=10)
    @SchemaAnnotations.StringSchema
    public String kerberosSpn();

    @SchemaAnnotations.Property(title="kerberosPrincipal", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=11)
    @SchemaAnnotations.StringSchema
    public String kerberosPrincipal();

    @SchemaAnnotations.Property(title="kerberosKeytabFile", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=12)
    @SchemaAnnotations.StringSchema
    public String kerberosKeytabFile();

    @SchemaAnnotations.Property(title="kerberosKeytabBase64", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=13)
    @SchemaAnnotations.StringSchema
    public String kerberosKeytabBase64();

    @SchemaAnnotations.Property(title="kerberosPassword", description="This property is no longer in use, and is only in place due to backwards compatible configuration validation purposes.", order=14, hints={"secret"})
    @SchemaAnnotations.StringSchema
    public String kerberosPassword();

    @SchemaAnnotations.Property(title="Obey robots.txt", description="If true, Allow, Disallow and other rules found in a robots.txt file will be obeyed.", order=15)
    @SchemaAnnotations.BooleanSchema
    public Boolean obeyRobots();

    @SchemaAnnotations.Property(title="Obey robots meta tags and headers", description="If true, rules like 'noindex', 'nofollow' and others found in a robots meta tag on a page or in the headers of the HTTP response are obeyed.", order=16)
    @SchemaAnnotations.BooleanSchema
    public Boolean obeyRobotsMeta();

    @SchemaAnnotations.Property(title="Obey link nofollow attributes", description="If true, rel='nofollow' on links are obeyed", order=17)
    @SchemaAnnotations.BooleanSchema
    public Boolean obeyLinkNofollow();

    @SchemaAnnotations.Property(title="HTTP proxy address", description="Address of the HTTP proxy, if required. This should be entered in the format host:port.", order=18)
    @SchemaAnnotations.StringSchema
    public String proxy();

    @SchemaAnnotations.Property(title="Allow all HTTPS certificates", description="If false, security checks will be performed on all SSL/TLS certificate signers and origins. This means self-signed certificates would not be supported.", order=19)
    @SchemaAnnotations.BooleanSchema
    public Boolean allowAllCertificates();

    @SchemaAnnotations.Property(title="Use IP address for SSL connections", description="Use IP address instead of host name for SSL connections. This is used to work around mis-configured HTTP server throwing 'unrecognized name' error whenSNI is enabled. (This only works if 'Allow all certificates' setting is also enabled)", order=20)
    @SchemaAnnotations.BooleanSchema
    public Boolean useIpAddressForSslConnections();

    @SchemaAnnotations.Property(title="Access Token", description="Access Token will be automatically requested using this request. Secret params that are set up below will be added automatically.", order=21)
    public AccessTokenConfig accessTokenConfig();
}

