/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.FetchDelay;
import com.lucidworks.connector.plugins.web.fetcher.JsEvaluator;
import com.lucidworks.connector.plugins.web.fetcher.LinkRewriter;
import com.lucidworks.connector.plugins.web.fetcher.WebContentProcessor;
import com.lucidworks.connector.plugins.web.fetcher.WebFetcher;
import com.lucidworks.connector.plugins.web.fetcher.http.HttpLinkNormalizer;
import com.lucidworks.connector.plugins.web.fetcher.http.RobotsTxt;
import com.lucidworks.connector.plugins.web.fetcher.http.client.HttpClientProvider;
import com.lucidworks.connector.plugins.web.fetcher.http.client.LinkValidator;
import com.lucidworks.connector.plugins.web.fetcher.http.client.RequestExecutor;
import com.lucidworks.connector.plugins.web.fetcher.http.client.WebClient;
import com.lucidworks.connector.plugins.web.fetcher.http.login.CredentialsWrapper;
import com.lucidworks.connector.plugins.web.fetcher.http.login.WebCookieStore;
import com.lucidworks.connector.plugins.web.fetcher.http.tokenauth.AccessTokenRequester;
import com.lucidworks.connector.plugins.web.fetcher.http.tokenauth.AccessTokenRequesterProvider;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlRules;
import com.lucidworks.connector.plugins.web.fetcher.sitemap.SitemapClient;
import com.lucidworks.connector.plugins.web.fetcher.sitemap.SitemapLinks;
import com.lucidworks.connector.plugins.web.fetcher.webdriver.DefaultWebDriverPool;
import com.lucidworks.connector.plugins.web.fetcher.webdriver.SeleniumSessionCleanUp;
import com.lucidworks.connector.plugins.web.fetcher.webdriver.WebDriverPool;
import com.lucidworks.connector.plugins.web.validator.WebValidator;
import com.lucidworks.fusion.connector.plugin.api.plugin.ConnectorPlugin;
import com.lucidworks.fusion.connector.plugin.api.plugin.ConnectorPluginProvider;
import org.apache.http.impl.client.CloseableHttpClient;

public class WebPlugin
implements ConnectorPluginProvider {
    public ConnectorPlugin get() {
        AbstractModule fetchModule = new AbstractModule(){

            protected void configure() {
                this.bind(WebClient.class).in(Singleton.class);
                this.bind(JsEvaluator.class).in(Singleton.class);
                this.bind(CloseableHttpClient.class).toProvider(HttpClientProvider.class).in(Singleton.class);
                this.bind(LinkValidator.class).in(Singleton.class);
                this.bind(HttpLinkNormalizer.class).in(Singleton.class);
                this.bind(RobotsTxt.class).in(Singleton.class);
                this.bind(AccessTokenRequester.class).toProvider(AccessTokenRequesterProvider.class).in(Singleton.class);
                this.bind(WebContentProcessor.class).in(Singleton.class);
                this.bind(CredentialsWrapper.class).in(Singleton.class);
                this.bind(RecrawlRules.class).in(Singleton.class);
                this.bind(FetchDelay.class).in(Singleton.class);
                this.bind(RequestExecutor.class).in(Singleton.class);
                this.bind(SitemapClient.class).in(Singleton.class);
                this.bind(SitemapLinks.class).in(Singleton.class);
                this.bind(LinkRewriter.class).in(Singleton.class);
                this.bind(WebCookieStore.class).toProvider(WebCookieStore::new).in(Singleton.class);
                this.bind(SeleniumSessionCleanUp.class).in(Singleton.class);
                this.bind(WebDriverPool.class).to(DefaultWebDriverPool.class).in(Singleton.class);
            }
        };
        return ConnectorPlugin.builder(WebConfig.class).withFetcher("content", WebFetcher.class, new Module[]{fetchModule}).withValidator(WebValidator.class, new Module[]{fetchModule}).build();
    }
}

