/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapIndex;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.sax.DelegatorHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLIndexHandler
extends DelegatorHandler {
    private SiteMapIndex sitemap;
    private StringBuilder loc;
    private boolean locClosed;
    private Date lastMod;
    private int i = 0;

    XMLIndexHandler(URL url, LinkedList<String> elementStack, boolean strict) {
        super(elementStack, strict);
        this.sitemap = new SiteMapIndex(url);
        this.sitemap.setType(AbstractSiteMap.SitemapType.INDEX);
        this.loc = new StringBuilder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isStrictNamespace() && !this.isAcceptedNamespace(uri)) {
            return;
        }
        if ("sitemap".equals(this.currentElement())) {
            this.maybeAddSiteMap();
        } else if ("sitemapindex".equals(this.currentElement())) {
            this.sitemap.setProcessed(true);
        } else if ("loc".equals(this.currentElement())) {
            this.locClosed = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String localName = super.currentElement();
        String value = String.valueOf(ch, start, length);
        if ("loc".equals(localName)) {
            this.loc.append(value);
        } else if ("lastmod".equals(localName)) {
            this.lastMod = SiteMap.convertToDate(value);
        } else if (!(value = value.trim()).isEmpty() && !this.locClosed) {
            this.loc.append(value);
        }
    }

    @Override
    public AbstractSiteMap getSiteMap() {
        return this.sitemap;
    }

    private void maybeAddSiteMap() {
        String value = this.loc.toString().trim();
        try {
            URL locURL = new URL(value);
            SiteMap s = new SiteMap(locURL, this.lastMod);
            this.sitemap.addSitemap(s);
            SiteMapParser.LOG.debug("  {}. {}", (Object)(this.i + 1), (Object)s);
        }
        catch (MalformedURLException e) {
            SiteMapParser.LOG.trace("Don't create an entry with a bad URL", (Throwable)e);
            SiteMapParser.LOG.debug("Bad url: [{}]", (Object)value);
        }
        this.loc = new StringBuilder();
        this.locClosed = false;
        this.lastMod = null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.maybeAddSiteMap();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.maybeAddSiteMap();
    }
}

