/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.SiteMapURL;
import crawlercommons.sitemaps.sax.DelegatorHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class RSSHandler
extends DelegatorHandler {
    private SiteMap sitemap;
    private StringBuilder loc;
    private URL locURL;
    private String lastMod;
    boolean valid;

    RSSHandler(URL url, LinkedList<String> elementStack, boolean strict) {
        super(elementStack, strict);
        this.sitemap = new SiteMap(url);
        this.sitemap.setType(AbstractSiteMap.SitemapType.RSS);
        this.loc = new StringBuilder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("link".equals(this.currentElement()) || "guid".equals(this.currentElement())) {
            this.setLocURL();
        } else if ("item".equals(this.currentElement())) {
            this.maybeAddSiteMapUrl();
        } else if ("rss".equals(this.currentElement())) {
            this.sitemap.setProcessed(true);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String localName = super.currentElement();
        String value = String.valueOf(ch, start, length);
        if ("pubDate".equals(localName)) {
            this.lastMod = AbstractSiteMap.normalizeRSSTimestamp(value);
            if ("channel".equals(super.currentElementParent())) {
                this.sitemap.setLastModified(this.lastMod);
            }
        } else if ("link".equals(localName)) {
            this.loc.append(value);
        } else if ("guid".equals(localName) && this.locURL == null) {
            this.loc.append(value);
        }
    }

    @Override
    public AbstractSiteMap getSiteMap() {
        return this.sitemap;
    }

    private void setLocURL() {
        String value = this.loc.toString().trim();
        if (value.isEmpty()) {
            return;
        }
        try {
            this.locURL = new URL(this.sitemap.getUrl(), value);
        }
        catch (MalformedURLException e) {
            SiteMapParser.LOG.debug("Bad url: [{}]", (Object)value);
            SiteMapParser.LOG.trace("Can't create an entry with a bad URL", (Throwable)e);
        }
        finally {
            this.loc = new StringBuilder();
        }
    }

    private void maybeAddSiteMapUrl() {
        if (this.locURL != null) {
            boolean valid = SiteMapParser.urlIsValid(this.sitemap.getBaseUrl(), this.locURL.toString());
            if (!this.isStrict() || valid) {
                SiteMapURL sUrl = new SiteMapURL(this.locURL, valid);
                sUrl.setLastModified(this.lastMod);
                this.sitemap.addSiteMapUrl(sUrl);
            }
        }
        this.locURL = null;
        this.lastMod = null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }
}

