/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.Namespace;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.UnknownFormatException;
import crawlercommons.sitemaps.sax.AtomHandler;
import crawlercommons.sitemaps.sax.RSSHandler;
import crawlercommons.sitemaps.sax.XMLHandler;
import crawlercommons.sitemaps.sax.XMLIndexHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DelegatorHandler
extends DefaultHandler {
    private LinkedList<String> elementStack;
    private DelegatorHandler delegate;
    private URL url;
    private boolean strict;
    private boolean strictNamespace;
    private UnknownFormatException exception;
    private Set<String> acceptedNamespaces;

    protected DelegatorHandler(LinkedList<String> elementStack, boolean strict) {
        this.elementStack = elementStack;
        this.strict = strict;
    }

    public DelegatorHandler(URL url, boolean strict) {
        this.elementStack = new LinkedList();
        this.url = url;
        this.strict = strict;
    }

    protected URL getUrl() {
        return this.url;
    }

    protected boolean isStrict() {
        return this.strict;
    }

    protected boolean isStrictNamespace() {
        return this.strictNamespace;
    }

    public void setStrictNamespace(boolean s) {
        this.strictNamespace = s;
    }

    public void setAcceptedNamespaces(Set<String> acceptedSet) {
        this.acceptedNamespaces = acceptedSet;
    }

    protected boolean isAcceptedNamespace(String uri) {
        return this.acceptedNamespaces.contains(uri);
    }

    protected void setException(UnknownFormatException exception) {
        this.exception = exception;
    }

    public UnknownFormatException getException() {
        return this.exception;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.elementStack.isEmpty() || this.delegate == null) {
            this.startRootElement(uri, localName, qName, attributes);
        } else {
            this.elementStack.push(localName);
        }
        if (this.delegate != null) {
            this.delegate.startElement(uri, localName, qName, attributes);
        }
    }

    private void startRootElement(String uri, String localName, String qName, Attributes attributes) {
        this.elementStack.push(localName);
        if ("feed".equals(localName)) {
            this.delegate = new AtomHandler(this.url, this.elementStack, this.strict);
        } else if ("channel".equals(localName)) {
            this.delegate = new RSSHandler(this.url, this.elementStack, this.strict);
        } else if ("sitemapindex".equals(localName)) {
            this.delegate = new XMLIndexHandler(this.url, this.elementStack, this.strict);
        } else if ("urlset".equals(localName)) {
            this.delegate = new XMLHandler(this.url, this.elementStack, this.strict);
        } else {
            SiteMapParser.LOG.debug("Skipped unknown root element <{}> in {}", (Object)localName, (Object)this.url);
            return;
        }
        this.delegate.setStrictNamespace(this.isStrictNamespace());
        this.delegate.setAcceptedNamespaces(this.acceptedNamespaces);
        if (this.isStrictNamespace()) {
            if (this.delegate instanceof AtomHandler || this.delegate instanceof RSSHandler) {
                return;
            }
            if (!this.isAcceptedNamespace(uri) && uri.startsWith("/")) {
                try {
                    URL u = new URL(this.url, uri);
                    uri = u.toString();
                }
                catch (MalformedURLException e) {
                    SiteMapParser.LOG.warn("Failed to resolve relative namespace URI {} in sitemap {}", (Object)uri, (Object)this.url);
                }
            }
            if (!this.isAcceptedNamespace(uri)) {
                String msg = !Namespace.isSupported(uri) ? "Unsupported namespace <" + uri + ">" : "Namespace <" + uri + "> not accepted";
                this.setException(new UnknownFormatException(msg));
                this.delegate = null;
                return;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.delegate != null) {
            this.delegate.endElement(uri, localName, qName);
        }
        this.elementStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.delegate != null) {
            this.delegate.characters(ch, start, length);
        }
    }

    protected String currentElement() {
        return this.elementStack.peek();
    }

    protected String currentElementParent() {
        return this.elementStack.size() < 2 ? null : this.elementStack.get(1);
    }

    public AbstractSiteMap getSiteMap() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getSiteMap();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.delegate != null) {
            this.delegate.error(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (this.delegate != null) {
            this.delegate.fatalError(e);
        }
    }
}

