/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.SiteMap;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public abstract class AbstractSiteMap {
    private static final Pattern W3C_NO_SECONDS_PATTERN = Pattern.compile("(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\dT\\d\\d:\\d\\d)(\\-|\\+)(\\d\\d):(\\d\\d)");
    private static final ThreadLocal<DateFormat> W3C_NO_SECONDS_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ", Locale.ROOT);
        }
    };
    private static final ThreadLocal<DateFormat> W3C_FULLDATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX", Locale.ROOT);
            result.setTimeZone(TimeZone.getTimeZone("UTC"));
            return result;
        }
    };
    private static final ThreadLocal<DateFormat> W3C_FULLDATE_FORMAT_WITH_OFFSET = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ROOT);
            result.setTimeZone(TimeZone.getTimeZone("UTC"));
            return result;
        }
    };
    private static final ThreadLocal<DateFormat[]> RSS_DATE_FORMATS = new ThreadLocal<DateFormat[]>(){

        @Override
        protected DateFormat[] initialValue() {
            return new DateFormat[]{new SimpleDateFormat("EEE, dd MMM yy HH:mm:ss Z", Locale.ROOT), new SimpleDateFormat("dd MMM yy HH:mm:ss Z", Locale.ROOT), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ROOT), new SimpleDateFormat("dd MMM yyyy HH:mm:ss Z", Locale.ROOT)};
        }
    };
    private Date lastModified = null;
    private SitemapType type;
    private boolean processed;
    protected URL url;

    public static DateFormat getFullDateFormat() {
        return W3C_FULLDATE_FORMAT.get();
    }

    public boolean isIndex() {
        return this.type == SitemapType.INDEX;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setType(SitemapType type) {
        this.type = type;
    }

    public SitemapType getType() {
        return this.type;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = SiteMap.convertToDate(lastModified);
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public static Date convertToDate(String date) {
        if (date == null) {
            return null;
        }
        try {
            return AbstractSiteMap.getFullDateFormat().parse(date);
        }
        catch (ParseException parseException) {
            try {
                return DatatypeConverter.parseDateTime((String)date).getTime();
            }
            catch (IllegalArgumentException e) {
                Matcher m = W3C_NO_SECONDS_PATTERN.matcher(date);
                if (m.matches()) {
                    try {
                        StringBuffer mungedDate = new StringBuffer(m.group(1));
                        mungedDate.append(m.group(2));
                        mungedDate.append(m.group(3));
                        mungedDate.append(m.group(4));
                        return W3C_NO_SECONDS_FORMAT.get().parse(mungedDate.toString());
                    }
                    catch (ParseException e2) {
                        return null;
                    }
                }
                return null;
            }
        }
    }

    public static String normalizeRSSTimestamp(String pubDate) {
        if (pubDate == null) {
            return null;
        }
        Date date = null;
        for (DateFormat format : RSS_DATE_FORMATS.get()) {
            try {
                date = format.parse(pubDate);
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (date == null) {
            return pubDate;
        }
        return W3C_FULLDATE_FORMAT_WITH_OFFSET.get().format(date);
    }

    public static enum SitemapType {
        INDEX,
        XML,
        ATOM,
        RSS,
        TEXT;

    }
}

