/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.robots;

import crawlercommons.robots.BaseRobotRules;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleRobotRules
extends BaseRobotRules {
    protected ArrayList<RobotRule> _rules;
    protected RobotRulesMode _mode;

    public SimpleRobotRules() {
        this(RobotRulesMode.ALLOW_SOME);
    }

    public SimpleRobotRules(RobotRulesMode mode) {
        this._mode = mode;
        this._rules = new ArrayList();
    }

    public void clearRules() {
        this._rules.clear();
    }

    public void addRule(String prefix, boolean allow) {
        if (!allow && prefix.length() == 0) {
            allow = true;
        }
        this._rules.add(new RobotRule(prefix, allow));
    }

    public List<RobotRule> getRobotRules() {
        return this._rules;
    }

    @Override
    public boolean isAllowed(String url) {
        if (this._mode == RobotRulesMode.ALLOW_NONE) {
            return false;
        }
        if (this._mode == RobotRulesMode.ALLOW_ALL) {
            return true;
        }
        String pathWithQuery = this.getPath(url, true);
        if (pathWithQuery.equals("/robots.txt")) {
            return true;
        }
        for (RobotRule rule : this._rules) {
            if (!this.ruleMatches(pathWithQuery, rule._prefix)) continue;
            return rule._allow;
        }
        return true;
    }

    private String getPath(String url, boolean getWithQuery) {
        try {
            URL urlObj = new URL(url);
            String path = urlObj.getPath();
            String query = urlObj.getQuery();
            if (getWithQuery && query != null) {
                path = path + "?" + query;
            }
            if (path == null || path.equals("")) {
                return "/";
            }
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (Exception e) {
            return "/";
        }
    }

    private boolean ruleMatches(String text, String pattern) {
        int patternPos = 0;
        int textPos = 0;
        int patternEnd = pattern.length();
        int textEnd = text.length();
        boolean containsEndChar = pattern.endsWith("$");
        if (containsEndChar) {
            --patternEnd;
        }
        while (patternPos < patternEnd && textPos < textEnd) {
            int wildcardPos = pattern.indexOf(42, patternPos);
            if (wildcardPos == -1) {
                wildcardPos = patternEnd;
            }
            if (wildcardPos == patternPos) {
                if (++patternPos >= patternEnd) {
                    return true;
                }
                int patternPieceEnd = pattern.indexOf(42, patternPos);
                if (patternPieceEnd == -1) {
                    patternPieceEnd = patternEnd;
                }
                boolean matched = false;
                int patternPieceLen = patternPieceEnd - patternPos;
                while (textPos + patternPieceLen <= textEnd && !matched) {
                    matched = true;
                    for (int i = 0; i < patternPieceLen && matched; ++i) {
                        if (text.charAt(textPos + i) == pattern.charAt(patternPos + i)) continue;
                        matched = false;
                    }
                    if (matched) continue;
                    ++textPos;
                }
                if (matched) continue;
                return false;
            }
            while (patternPos < wildcardPos && textPos < textEnd) {
                if (text.charAt(textPos++) == pattern.charAt(patternPos++)) continue;
                return false;
            }
        }
        while (patternPos < patternEnd && pattern.charAt(patternPos) == '*') {
            ++patternPos;
        }
        return patternPos == patternEnd && (textPos == textEnd || !containsEndChar);
    }

    public void sortRules() {
        Collections.sort(this._rules);
    }

    @Override
    public boolean isAllowAll() {
        return this._mode == RobotRulesMode.ALLOW_ALL;
    }

    @Override
    public boolean isAllowNone() {
        return this._mode == RobotRulesMode.ALLOW_NONE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._mode == null ? 0 : this._mode.hashCode());
        result = 31 * result + (this._rules == null ? 0 : this._rules.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleRobotRules other = (SimpleRobotRules)obj;
        if (this._mode != other._mode) {
            return false;
        }
        return !(this._rules == null ? other._rules != null : !this._rules.equals(other._rules));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        int nRules = this._rules.size();
        if (nRules == 0) {
            sb.append(" - no rules");
            if (this.isAllowNone()) {
                sb.append(" (allow none)");
            } else if (this.isAllowAll()) {
                sb.append(" (allow all)");
            }
            sb.append('\n');
        } else {
            sb.append(" - number of rules: ").append(nRules).append('\n');
            if (nRules <= 10) {
                for (int i = 0; i < nRules; ++i) {
                    RobotRule r = this._rules.get(i);
                    sb.append(r._allow ? "   A" : "   Disa").append("llow: ").append(r._prefix).append('\n');
                }
            }
        }
        return sb.toString();
    }

    public static class RobotRule
    implements Comparable<RobotRule>,
    Serializable {
        String _prefix;
        boolean _allow;

        public RobotRule(String prefix, boolean allow) {
            this._prefix = prefix;
            this._allow = allow;
        }

        public boolean isAllow() {
            return this._allow;
        }

        public String getPrefix() {
            return this._prefix;
        }

        @Override
        public int compareTo(RobotRule o) {
            if (this._prefix.length() < o._prefix.length()) {
                return 1;
            }
            if (this._prefix.length() > o._prefix.length()) {
                return -1;
            }
            if (this._allow == o._allow) {
                return 0;
            }
            if (this._allow) {
                return -1;
            }
            return 1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._allow ? 1231 : 1237);
            result = 31 * result + (this._prefix == null ? 0 : this._prefix.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RobotRule other = (RobotRule)obj;
            if (this._allow != other._allow) {
                return false;
            }
            return !(this._prefix == null ? other._prefix != null : !this._prefix.equals(other._prefix));
        }
    }

    public static enum RobotRulesMode {
        ALLOW_ALL,
        ALLOW_NONE,
        ALLOW_SOME;

    }
}

