/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.filters.basic;

import crawlercommons.filters.URLFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicURLNormalizer
extends URLFilter {
    public static final Logger LOG = LoggerFactory.getLogger(BasicURLNormalizer.class);
    private static final Pattern hasNormalizablePathPattern = Pattern.compile("/[./]|[.]/");
    private static final Pattern unescapeRulePattern = Pattern.compile("%([0-9A-Fa-f]{2})");
    private static final boolean[] unescapedCharacters = new boolean[128];

    @Override
    public String filter(String urlString) {
        String file2;
        if ("".equals(urlString)) {
            return urlString;
        }
        urlString = urlString.trim();
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.info("Malformed URL {}", (Object)urlString);
            return null;
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String file = url.getFile();
        boolean changed = false;
        if (!urlString.startsWith(protocol)) {
            changed = true;
        }
        if ("http".equals(protocol) || "https".equals(protocol) || "ftp".equals(protocol)) {
            if (host != null && url.getAuthority() != null) {
                String newHost = host.toLowerCase(Locale.ROOT);
                if (!host.equals(newHost)) {
                    host = newHost;
                    changed = true;
                } else if (!url.getAuthority().equals(newHost)) {
                    changed = true;
                }
            } else {
                changed = true;
            }
            if (port == url.getDefaultPort()) {
                port = -1;
                changed = true;
            }
            if (file == null || "".equals(file)) {
                file = "/";
                changed = true;
            }
            if (url.getRef() != null) {
                changed = true;
            }
            file2 = null;
            try {
                file2 = this.getFileWithNormalizedPath(url);
            }
            catch (MalformedURLException e) {
                LOG.info("Malformed URL {}", (Object)url);
                return null;
            }
            if (!file.equals(file2)) {
                changed = true;
                file = file2;
            }
        }
        file2 = this.unescapePath(file);
        if (!file.equals(file2 = this.escapePath(file2))) {
            changed = true;
            file = file2;
        }
        if (changed) {
            try {
                urlString = new URL(protocol, host, port, file).toString();
            }
            catch (MalformedURLException e) {
                LOG.info("Malformed URL {}{}{}{}", new Object[]{protocol, host, port, file});
                return null;
            }
        }
        return urlString;
    }

    private String getFileWithNormalizedPath(URL url) throws MalformedURLException {
        String file;
        if (hasNormalizablePathPattern.matcher(url.getPath()).find()) {
            try {
                file = url.toURI().normalize().toURL().getFile();
                int start = 0;
                while (file.startsWith("/../", start)) {
                    start += 3;
                }
                if (start > 0) {
                    file = file.substring(start);
                }
            }
            catch (URISyntaxException e) {
                file = url.getFile();
            }
        } else {
            file = url.getFile();
        }
        if (file.isEmpty()) {
            file = "/";
        }
        return file;
    }

    private String unescapePath(String path) {
        int letter;
        StringBuilder sb = new StringBuilder();
        Matcher matcher = unescapeRulePattern.matcher(path);
        int end = -1;
        while (matcher.find()) {
            sb.append(path.substring(end + 1, matcher.start()));
            letter = Integer.valueOf(matcher.group().substring(1), 16);
            if (letter < 128 && unescapedCharacters[letter]) {
                sb.append(new Character((char)letter));
            } else {
                sb.append(matcher.group().toUpperCase(Locale.ROOT));
            }
            end = matcher.start() + 2;
        }
        letter = path.length();
        if (end <= letter - 1) {
            sb.append(path.substring(end + 1, letter));
        }
        return sb.toString();
    }

    private String escapePath(String path) {
        StringBuilder sb = new StringBuilder(path.length());
        for (byte b : path.getBytes(StandardCharsets.UTF_8)) {
            if (b < 33 || b == 91 || b == 93) {
                sb.append('%');
                String hex = Integer.toHexString(b & 0xFF).toUpperCase(Locale.ROOT);
                if (hex.length() % 2 != 0) {
                    sb.append('0');
                    sb.append(hex);
                    continue;
                }
                sb.append(hex);
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        String line;
        BasicURLNormalizer normalizer = new BasicURLNormalizer();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        while ((line = in.readLine()) != null) {
            String normUrl = normalizer.filter(line);
            LOG.info("{} => {}", (Object)line, (Object)normUrl);
        }
        System.exit(0);
    }

    static {
        for (int c = 0; c < 128; ++c) {
            BasicURLNormalizer.unescapedCharacters[c] = 65 <= c && c <= 90 || 97 <= c && c <= 122 || 48 <= c && c <= 57 || c == 45 || c == 46 || c == 95 || c == 126;
        }
    }
}

