/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import java.io.File;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.manager.SeleniumManager;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.remote.service.DriverService;

public class DriverFinder {
    private static final Logger LOG = Logger.getLogger(DriverFinder.class.getName());

    public static String getPath(DriverService service, Capabilities options) {
        Require.nonNull((String)"Browser options", (Object)options);
        String defaultPath = new ExecutableFinder().find(service.getDriverName());
        String exePath = System.getProperty(service.getDriverProperty(), defaultPath);
        if (exePath == null && service.getDriverExecutable() != null) {
            exePath = service.getDriverExecutable().getAbsolutePath();
        }
        if (exePath == null) {
            try {
                exePath = SeleniumManager.getInstance().getDriverPath(options);
            }
            catch (Exception e) {
                LOG.warning(String.format("Unable to obtain %s using Selenium Manager: %s", service.getDriverName(), e.getMessage()));
            }
        }
        String validPath = (String)Require.state((String)"The path to the driver executable", (Object)exePath).nonNull("Unable to locate the %s executable; for more information on how to install drivers, see https://www.selenium.dev/documentation/webdriver/getting_started/install_drivers/", new Object[]{service.getDriverName()});
        File exe = new File(validPath);
        Require.state((String)"The driver executable", (File)exe).isFile();
        Require.stateCondition((boolean)exe.canExecute(), (String)"It must be an executable file: %s", (Object[])new Object[]{exe});
        return validPath;
    }
}

