/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.logging.Level;

public enum ChromiumDriverLogLevel {
    ALL,
    INFO,
    DEBUG,
    WARNING,
    SEVERE,
    OFF;

    private static final Map<Level, ChromiumDriverLogLevel> logLevelToChromeLevelMap;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static ChromiumDriverLogLevel fromString(String text) {
        if (text != null) {
            for (ChromiumDriverLogLevel b : ChromiumDriverLogLevel.values()) {
                if (!text.equalsIgnoreCase(b.toString())) continue;
                return b;
            }
        }
        return null;
    }

    public static ChromiumDriverLogLevel fromLevel(Level level) {
        return logLevelToChromeLevelMap.getOrDefault(level, ALL);
    }

    static {
        logLevelToChromeLevelMap = new ImmutableMap.Builder().put((Object)Level.ALL, (Object)ALL).put((Object)Level.FINEST, (Object)DEBUG).put((Object)Level.FINER, (Object)DEBUG).put((Object)Level.FINE, (Object)DEBUG).put((Object)Level.INFO, (Object)INFO).put((Object)Level.WARNING, (Object)WARNING).put((Object)Level.SEVERE, (Object)SEVERE).put((Object)Level.OFF, (Object)OFF).build();
    }
}

