/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.HasCdp;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;

public abstract class AddHasCdp
implements AugmenterProvider<HasCdp>,
AdditionalHttpCommands {
    public static final String EXECUTE_CDP = "executeCdpCommand";

    public abstract Map<String, CommandInfo> getAdditionalCommands();

    public Predicate<Capabilities> isApplicable() {
        return caps -> ChromiumDriver.IS_CHROMIUM_BROWSER.test(caps.getBrowserName());
    }

    public Class<HasCdp> getDescribedInterface() {
        return HasCdp.class;
    }

    public HasCdp getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasCdp(){

            @Override
            public Map<String, Object> executeCdpCommand(String commandName, Map<String, Object> parameters) {
                Require.nonNull((String)"Command name", (Object)commandName);
                Require.nonNull((String)"Parameters", parameters);
                Map toReturn = (Map)executeMethod.execute(AddHasCdp.EXECUTE_CDP, (Map)ImmutableMap.of((Object)"cmd", (Object)commandName, (Object)"params", parameters));
                return ImmutableMap.copyOf((Map)toReturn);
            }
        };
    }
}

