/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.events.EventEmitterBuilder;
import io.opentelemetry.api.events.EventEmitterProvider;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.api.logs.LoggerBuilder;
import io.opentelemetry.api.logs.LoggerProvider;

public final class SdkEventEmitterProvider
implements EventEmitterProvider {
    private static final String DEFAULT_EVENT_DOMAIN = "unknown";
    private final LoggerProvider delegateLoggerProvider;

    private SdkEventEmitterProvider(LoggerProvider delegateLoggerProvider) {
        this.delegateLoggerProvider = delegateLoggerProvider;
    }

    public static SdkEventEmitterProvider create(LoggerProvider delegateLoggerProvider) {
        return new SdkEventEmitterProvider(delegateLoggerProvider);
    }

    public EventEmitter get(String instrumentationScopeName) {
        return this.eventEmitterBuilder(instrumentationScopeName).setEventDomain(DEFAULT_EVENT_DOMAIN).build();
    }

    public EventEmitterBuilder eventEmitterBuilder(String instrumentationScopeName) {
        return new SdkEventEmitterBuilder(this.delegateLoggerProvider.loggerBuilder(instrumentationScopeName));
    }

    private static class SdkEventEmitterBuilder
    implements EventEmitterBuilder {
        private final LoggerBuilder delegateLoggerBuilder;
        private String eventDomain = "unknown";

        private SdkEventEmitterBuilder(LoggerBuilder delegateLoggerBuilder) {
            this.delegateLoggerBuilder = delegateLoggerBuilder;
        }

        public EventEmitterBuilder setEventDomain(String eventDomain) {
            this.eventDomain = eventDomain;
            return this;
        }

        public EventEmitterBuilder setSchemaUrl(String schemaUrl) {
            this.delegateLoggerBuilder.setSchemaUrl(schemaUrl);
            return this;
        }

        public EventEmitterBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegateLoggerBuilder.setInstrumentationVersion(instrumentationScopeVersion);
            return this;
        }

        public EventEmitter build() {
            return new SdkEventEmitter(this.delegateLoggerBuilder.build(), this.eventDomain);
        }
    }

    private static class SdkEventEmitter
    implements EventEmitter {
        private static final AttributeKey<String> EVENT_DOMAIN = AttributeKey.stringKey((String)"event.domain");
        private static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey((String)"event.name");
        private final Logger delegateLogger;
        private final String eventDomain;

        private SdkEventEmitter(Logger delegateLogger, String eventDomain) {
            this.delegateLogger = delegateLogger;
            this.eventDomain = eventDomain;
        }

        public void emit(String eventName, Attributes attributes) {
            this.delegateLogger.logRecordBuilder().setAllAttributes(attributes).setAttribute(EVENT_DOMAIN, (Object)this.eventDomain).setAttribute(EVENT_NAME, (Object)eventName).emit();
        }
    }
}

