/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.fusion.connector.checker.processor;

import com.google.common.collect.Lists;
import com.lucidworks.fusion.connector.checker.checkers.Checker;
import com.lucidworks.fusion.connector.checker.checkers.factory.CheckerFactory;
import com.lucidworks.fusion.connector.checker.output.CheckerResult;
import com.lucidworks.fusion.connector.checker.output.PassedCheckerResult;
import com.lucidworks.fusion.connector.checker.processor.CheckerProcessor;
import com.lucidworks.fusion.schema.Model;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;

public class DefaultCheckerProcessor<T>
implements CheckerProcessor<T> {
    private final List<RuntimeChecker> checkers = Lists.newArrayList();
    private final CheckerFactory factory;

    @Inject
    public DefaultCheckerProcessor(CheckerFactory factory) {
        this.factory = factory;
    }

    @Override
    public CheckerResult process(T input) {
        return this.checkers.stream().filter(mappedChecker -> mappedChecker.test(input)).map(mappedChecker -> mappedChecker.process(input)).filter(CheckerResult::failed).findFirst().orElse(PassedCheckerResult.passedResult());
    }

    @Override
    public <R> void add(Checker<R> checker, Function<T, R> mapper) {
        this.add((Model)checker, input -> true, mapper);
    }

    @Override
    public <R> void add(Checker<R> checker, Predicate<T> inputTest, Function<T, R> mapper) {
        this.checkers.add(new RuntimeChecker<R>(checker, inputTest, mapper));
    }

    @Override
    public <R, C extends Model> void add(C config, Predicate<T> testInput, Function<T, R> mapper) {
        Optional checker = this.factory.create(config);
        checker.ifPresent(tChecker -> this.add((Model)tChecker, testInput, mapper));
    }

    @Override
    public <R, C extends Model> void add(C config, Function<T, R> mapper) {
        this.add(config, (T input) -> true, mapper);
    }

    @Override
    public <R> void add(Checker<R> checker, Predicate<T> testInput) {
        this.add((Model)checker, testInput, input -> input);
    }

    @Override
    public <R> void add(Checker<R> checker) {
        this.add(checker, (T input) -> true);
    }

    public class RuntimeChecker<R>
    implements Predicate<T>,
    Function<T, R> {
        private final Checker<R> checker;
        private final Predicate<T> inputTest;
        private final Function<T, R> mapper;

        public RuntimeChecker(Checker<R> checker, Predicate<T> inputTest, Function<T, R> mapper) {
            this.checker = checker;
            this.inputTest = inputTest;
            this.mapper = mapper;
        }

        CheckerResult process(T input) {
            return (CheckerResult)this.checker.apply(this.apply(input));
        }

        @Override
        public R apply(T input) {
            return this.mapper.apply(input);
        }

        @Override
        public boolean test(T input) {
            return this.inputTest.test(input);
        }
    }
}

