/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.fusion.connector.checker.checkers.pattern;

import com.google.common.io.Files;
import com.lucidworks.fusion.connector.checker.checkers.pattern.AbstractPatternChecker;
import com.lucidworks.fusion.connector.checker.config.ExtensionConfig;
import com.lucidworks.fusion.connector.checker.input.NamedCheckerInput;
import com.lucidworks.fusion.connector.checker.output.CheckerResult;
import com.lucidworks.fusion.connector.checker.output.FailedCheckerResult;
import com.lucidworks.fusion.connector.checker.output.PassedCheckerResult;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionChecker
extends AbstractPatternChecker {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionChecker.class);
    public static final String EXCLUDED_EXTENSION = "excluded-extension";
    public static final String NOT_INCLUDED_EXTENSION = "not-included-extension";
    private final Set<String> excludeExtensions;
    private final Set<String> includeExtensions;

    public ExtensionChecker(ExtensionConfig.Properties extensionConfig) {
        super(extensionConfig.regexCacheSize());
        this.includeExtensions = extensionConfig.includedFileExtensions().stream().map(this::normalize).collect(Collectors.toSet());
        this.excludeExtensions = extensionConfig.excludedFileExtensions().stream().map(this::normalize).collect(Collectors.toSet());
    }

    private String normalize(String extension) {
        if (extension.startsWith(".")) {
            return extension.substring(1);
        }
        return extension;
    }

    private boolean validateExtension(String extension, String filename) {
        String fileExtension = FilenameUtils.getExtension((String)filename);
        if (!extension.contains(".")) {
            return extension.equalsIgnoreCase(fileExtension);
        }
        String currentExtension = FilenameUtils.getExtension((String)extension);
        return currentExtension.equalsIgnoreCase(fileExtension) && this.validateExtension(Files.getNameWithoutExtension((String)extension), Files.getNameWithoutExtension((String)filename));
    }

    @Override
    protected CheckerResult specificCheck(NamedCheckerInput namedCheckerInput) {
        String name = namedCheckerInput.getName();
        if (this.isExcluded(name)) {
            logger.debug("Name matches exclude-extension pattern: '{}'", (Object)name);
            return FailedCheckerResult.failedResult(EXCLUDED_EXTENSION);
        }
        if (this.isNotIncluded(name)) {
            logger.debug("Name does not match any include-extension pattern: '{}'", (Object)name);
            return FailedCheckerResult.failedResult(NOT_INCLUDED_EXTENSION);
        }
        return new PassedCheckerResult();
    }

    private boolean isExcluded(String name) {
        return this.excludeExtensions.stream().anyMatch(extension -> this.validateExtension((String)extension, name));
    }

    private boolean isNotIncluded(String name) {
        return !this.includeExtensions.isEmpty() && this.includeExtensions.stream().noneMatch(extension -> this.validateExtension((String)extension, name));
    }
}

