/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.util;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String TAB = "\t";
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static Map<String, String> ENCODE_URL_REPLACEMENTS = new ConcurrentHashMap<String, String>(13);
    private static ThreadLocal<Set<Matcher>> ENCODE_URL_MATCHERS;

    private Utils() {
    }

    public static <T> T dequeue(BlockingQueue<T> queue) {
        T t = null;
        while (null == t) {
            try {
                t = queue.take();
            }
            catch (InterruptedException e) {
                Utils.handleInterrupt(e);
            }
        }
        return t;
    }

    public static void handleInterrupt(InterruptedException e) {
        Thread.currentThread().interrupt();
        throw new RuntimeException(e);
    }

    public static String tab(String str, int nTabs) {
        String tabs;
        if (nTabs < TABS.length) {
            tabs = TABS[nTabs];
        } else {
            StringBuilder tb = new StringBuilder();
            for (int i = 0; i < nTabs; ++i) {
                tb.append(TAB);
            }
            tabs = tb.toString();
        }
        String[] lines = str.split(NEWLINE);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(tabs).append(line).append(NEWLINE);
        }
        str = sb.toString();
        return str;
    }

    public static String encodeURL(String url) {
        Set<Matcher> matchers = ENCODE_URL_MATCHERS.get();
        for (Matcher matcher : matchers) {
            url = matcher.reset(url).replaceAll(Matcher.quoteReplacement(ENCODE_URL_REPLACEMENTS.get(matcher.pattern().pattern())));
        }
        return url;
    }

    public static ThreadLocal<Set<Matcher>> makeThreadLocalMatchers(Set<String> regexes) {
        return Utils.makeThreadLocalMatchers(regexes, 0);
    }

    public static ThreadLocal<Set<Matcher>> makeThreadLocalMatchers(final Set<String> regexes, final int flags) {
        return new ThreadLocal<Set<Matcher>>(){

            @Override
            public Set<Matcher> initialValue() {
                LinkedHashSet<Matcher> matchers = new LinkedHashSet<Matcher>(regexes.size());
                for (String regex : regexes) {
                    matchers.add(Pattern.compile(regex, flags).matcher(""));
                }
                return matchers;
            }
        };
    }

    static {
        ENCODE_URL_REPLACEMENTS.put(" ", "%20");
        ENCODE_URL_REPLACEMENTS.put("\"", "%22");
        ENCODE_URL_REPLACEMENTS.put("<", "%3C");
        ENCODE_URL_REPLACEMENTS.put(">", "%3E");
        ENCODE_URL_REPLACEMENTS.put("#", "%23");
        ENCODE_URL_REPLACEMENTS.put("{", "%7B");
        ENCODE_URL_REPLACEMENTS.put("}", "%7D");
        ENCODE_URL_REPLACEMENTS.put("|", "%7C");
        ENCODE_URL_REPLACEMENTS.put("\\", "%5C");
        ENCODE_URL_REPLACEMENTS.put("^", "%5E");
        ENCODE_URL_REPLACEMENTS.put("[", "%5B");
        ENCODE_URL_REPLACEMENTS.put("]", "%5D");
        ENCODE_URL_REPLACEMENTS.put("`", "%60");
        ENCODE_URL_MATCHERS = Utils.makeThreadLocalMatchers(ENCODE_URL_REPLACEMENTS.keySet(), 16);
    }
}

