/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.util;

import com.lucidworks.connector.plugins.web.util.LRUCache;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LRUSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final Object IGNORE = new Object();
    private final Map cache;

    public LRUSet() {
        this(0, 10000, 0.75f, true);
    }

    public LRUSet(int maximumCacheSize) {
        this(0, maximumCacheSize, 0.75f, true);
    }

    public LRUSet(int initialCapacity, int maximumCacheSize, float loadFactor, boolean accessOrder) {
        this.cache = Collections.synchronizedMap(new LRUCache(initialCapacity, maximumCacheSize, loadFactor, accessOrder));
    }

    @Override
    public Iterator<E> iterator() {
        return this.cache.keySet().iterator();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.cache.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.cache.put(o, IGNORE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.cache.remove(o) == IGNORE;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

