/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.webdriver;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumSessionCleanUp {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SeleniumSessionCleanUp.class);
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    static String hubUrl = "http://selenium-hub:4444/wd/hub";

    public static List<String> getActiveSessionIds() throws IOException {
        ArrayList<String> sessionIds = new ArrayList<String>();
        String url = hubUrl + "/status";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        try {
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                throw new IOException("Failed to get active sessions. Status: " + response.statusCode() + ", Body: " + response.body());
            }
            Gson gson = new Gson();
            JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            JsonObject value = json.getAsJsonObject("value");
            JsonArray nodes = value.getAsJsonArray("nodes");
            logger.info("nodes: {}", (Object)nodes);
            for (int i = 0; i < nodes.size(); ++i) {
                JsonObject node = nodes.get(i).getAsJsonObject();
                JsonArray slots = node.getAsJsonArray("slots");
                for (int j = 0; j < slots.size(); ++j) {
                    JsonObject slot = slots.get(j).getAsJsonObject();
                    if (!slot.has("session") || slot.get("session").isJsonNull()) continue;
                    JsonObject session = slot.getAsJsonObject("session");
                    String sessionId = session.get("sessionId").getAsString();
                    sessionIds.add(sessionId);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Request was interrupted", e);
        }
        return sessionIds;
    }

    public static void deleteSession(String sessionId) {
        if ("reserved".equals(sessionId)) {
            return;
        }
        logger.info("Deleting session id:{}", (Object)sessionId);
        String url = hubUrl + "/session/" + sessionId;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).DELETE().build();
        try {
            logger.info("DELETE " + url);
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            logger.info("Response Code: " + response.statusCode());
            logger.info("Response Body: " + response.body());
        }
        catch (IOException e) {
            logger.error("Failed to delete session {}: {}", (Object)sessionId, (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Could not delete session {}: {}", (Object)sessionId, (Object)e.getMessage());
        }
    }

    public void runCleanUp() {
        try {
            List<String> activeSessionIds = SeleniumSessionCleanUp.getActiveSessionIds();
            while (!activeSessionIds.isEmpty()) {
                logger.info("Cleaning up active session ids: {}", activeSessionIds);
                activeSessionIds.forEach(SeleniumSessionCleanUp::deleteSession);
                activeSessionIds = SeleniumSessionCleanUp.getActiveSessionIds();
                this.sleep();
            }
        }
        catch (IOException e) {
            logger.error("Error cleaning up web driver sessions", (Throwable)e);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

