/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.recrawl;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.config.RecrawlRulesConfig;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.WebFetcher;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlAge;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlAll;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlErrors;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlExactIDs;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlIdPrefixes;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlIdRegexes;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlRule;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlScript;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlSitemap;
import com.lucidworks.connector.plugins.web.fetcher.script.DefaultScriptRunnerProvider;
import com.lucidworks.connector.plugins.web.fetcher.sitemap.SitemapLinks;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RecrawlRules {
    List<RecrawlRule> rules = new ArrayList<RecrawlRule>();

    @Inject
    public RecrawlRules(WebConfig config, SitemapLinks sitemapLinks) {
        RecrawlRulesConfig recrawlRulesConfig = config.properties().recrawlRulesConfig();
        if (!recrawlRulesConfig.refreshIDRegexes().isEmpty()) {
            this.rules.add(new RecrawlIdRegexes(recrawlRulesConfig));
        }
        if (!recrawlRulesConfig.refreshIDPrefixes().isEmpty()) {
            this.rules.add(new RecrawlIdPrefixes(recrawlRulesConfig));
        }
        if (StringUtils.isNotBlank((CharSequence)recrawlRulesConfig.refreshScript())) {
            this.rules.add(new RecrawlScript(recrawlRulesConfig, new DefaultScriptRunnerProvider().get()));
        }
        if (recrawlRulesConfig.refreshErrors().booleanValue()) {
            this.rules.add(new RecrawlErrors());
        }
        if (recrawlRulesConfig.sitemapIncrementalCrawling().booleanValue()) {
            this.rules.add(new RecrawlSitemap(sitemapLinks));
        }
        if (recrawlRulesConfig.refreshOlderThan() > -1) {
            this.rules.add(new RecrawlAge(recrawlRulesConfig.refreshOlderThan()));
        }
        if (recrawlRulesConfig.refreshStartLinks().booleanValue()) {
            List<String> startlinks = config.properties().startLinks();
            startlinks.addAll(WebFetcher.bulkStartLinkList(config));
            this.rules.add(new RecrawlExactIDs(startlinks));
        }
        if (recrawlRulesConfig.refreshAll().booleanValue()) {
            this.rules.add(new RecrawlAll());
        }
    }

    public boolean shouldSkip(FetchInput input) {
        return !this.shouldRecrawl(input, this.rules);
    }

    private boolean shouldRecrawl(FetchInput input, List<RecrawlRule> rules) {
        for (RecrawlRule rule : rules) {
            if (!rule.shouldRecrawl(input)) continue;
            return true;
        }
        return false;
    }
}

