/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.recrawl;

import com.lucidworks.connector.plugins.web.config.RecrawlRulesConfig;
import com.lucidworks.connector.plugins.web.fetcher.recrawl.RecrawlRule;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class RecrawlIdPrefixes
implements RecrawlRule {
    private final List<String> prefixes;

    public RecrawlIdPrefixes(RecrawlRulesConfig config) {
        this.prefixes = config.refreshIDPrefixes().stream().map(p -> p.toLowerCase(Locale.US)).collect(Collectors.toList());
    }

    @Override
    public boolean shouldRecrawl(FetchInput input) {
        return input.hasId() && this.reCrawlIDPrefix(input.getId());
    }

    private boolean reCrawlIDPrefix(String id) {
        return this.prefixes.stream().anyMatch(p -> id.toLowerCase(Locale.US).startsWith((String)p));
    }
}

