/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.tokenauth;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.AccessTokenConfig;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.http.tokenauth.AccessTokenRequester;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class AccessTokenRequesterProvider
implements Provider<AccessTokenRequester> {
    private final WebConfig config;
    private final CloseableHttpClient httpClient;

    @Inject
    public AccessTokenRequesterProvider(WebConfig config, CloseableHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
    }

    public AccessTokenRequester get() {
        AccessTokenConfig accessTokenConfig = this.config.properties().crawlAuthenticationConfig().accessTokenConfig();
        if (!StringUtils.isBlank((CharSequence)accessTokenConfig.requestUrl())) {
            return new AccessTokenRequester(HttpClients.createDefault(), accessTokenConfig.requestUrl(), this.buildAccessTokenRequestBody(accessTokenConfig));
        }
        return null;
    }

    private String buildAccessTokenRequestBody(AccessTokenConfig accessTokenConfig) {
        ArrayList params = new ArrayList();
        accessTokenConfig.params().forEach(p -> params.add(new BasicNameValuePair(p.name(), p.value())));
        accessTokenConfig.secretParams().forEach(p -> params.add(new BasicNameValuePair(p.name(), p.value())));
        try {
            return new URIBuilder().addParameters(params).build().getRawQuery();
        }
        catch (URISyntaxException e) {
            throw new WebConnectorException("Unable to configure Access Token Request", e);
        }
    }
}

