/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.tokenauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lucidworks.connector.plugins.web.fetcher.http.tokenauth.AccessTokenException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenRequester {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenRequester.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private CloseableHttpClient client;
    private final String url;
    private final String body;
    private String accessToken = "";
    private long tokenExpirationTime;

    public AccessTokenRequester(CloseableHttpClient client, String url, String body) {
        this.client = client;
        this.url = url;
        this.body = body;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBody() {
        return this.body;
    }

    public String getAccessToken() {
        if (this.tokenExpirationTime < System.currentTimeMillis()) {
            LOG.info("Access token expired.");
            this.accessToken = this.getNewAccessToken();
        }
        return this.accessToken;
    }

    public String getNewAccessToken() {
        return this.requestToken(this.accessToken);
    }

    private synchronized String requestToken(String currentToken) {
        if (!currentToken.equals(this.accessToken)) {
            return this.accessToken;
        }
        LOG.info("Requesting new access token");
        LOG.debug("Requesting new access token from: " + this.url);
        HttpPost request = new HttpPost(this.url);
        request.addHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded"));
        request.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setEntity((HttpEntity)new StringEntity(this.body, ContentType.APPLICATION_FORM_URLENCODED));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            Integer expiresIn;
            String responseStr = new String(response.getEntity().getContent().readAllBytes());
            Map result = (Map)objectMapper.readValue(responseStr, Map.class);
            LOG.debug("Access token request response: {}", (Object)responseStr);
            this.accessToken = (String)result.get("access_token");
            if (StringUtils.isBlank((CharSequence)this.accessToken)) {
                throw new AccessTokenException("Could not get access token. Request response: " + responseStr);
            }
            Integer n = expiresIn = (Integer)result.get("expires_in");
            Integer n2 = expiresIn = Integer.valueOf(expiresIn - 1);
            this.tokenExpirationTime = System.currentTimeMillis() + (long)(expiresIn * 1000);
        }
        catch (IOException e) {
            throw new AccessTokenException("Access token request failed.", e);
        }
        return this.accessToken;
    }
}

