/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.login;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.http.login.CredentialsWrapper;
import com.lucidworks.connector.plugins.web.fetcher.http.login.HttpCredential;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.joda.time.Instant;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverSmartFormLogin {
    public static final long SMART_FORM_LOGIN_EXTRA_WAIT_MS = Long.parseLong(System.getProperty("connectors.webdriver.smartFormLoginExtraWaitMs", "2000"));
    private final Logger logger = LoggerFactory.getLogger(WebDriverSmartFormLogin.class);
    public static final String SUBMIT_BUTTON_XPATH = "::submitButtonXPath::";
    public static final String WHEN_XPATH = "::whenXPath::";
    private final List<HttpCredential> credentials;
    private final long implicitWaitTimeout;
    private final long scriptTimeout;
    private final boolean diagnosticMode;
    private long latestLoginTTL = -1L;
    private Set<Cookie> latestCookies;
    private final BasicCookieStore basicCookieStore;
    private final boolean jsEnabledAuth;

    @Inject
    public WebDriverSmartFormLogin(CredentialsWrapper credentialsWrapper, WebConfig config, BasicCookieStore basicCookieStore) {
        this.credentials = credentialsWrapper.getCredentials();
        this.implicitWaitTimeout = config.properties().javascriptEvaluationConfig().jsScriptTimeout().intValue();
        this.scriptTimeout = config.properties().javascriptEvaluationConfig().jsAjaxTimeout().intValue();
        this.diagnosticMode = config.diagnosticLogging();
        this.basicCookieStore = basicCookieStore;
        this.jsEnabledAuth = config.properties().javascriptEvaluationConfig().jsEnabledAuth();
    }

    public long getLowestTTL(List<HttpCredential> credentials) {
        double lowestTTL = 9.223372036854776E18;
        for (HttpCredential credential : credentials) {
            double credTtl;
            try {
                credTtl = credential.getTTL();
            }
            catch (NullPointerException e) {
                credTtl = 9.223372036854776E18;
            }
            lowestTTL = Double.min(lowestTTL, credTtl);
        }
        return (long)lowestTTL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginIfNeeded(WebDriver webDriver) throws IOException {
        WebDriverSmartFormLogin webDriverSmartFormLogin = this;
        synchronized (webDriverSmartFormLogin) {
            long ttlTimeRemaining = this.latestLoginTTL + this.getLowestTTL(this.credentials) - Instant.now().getMillis();
            if (this.latestLoginTTL == -1L || ttlTimeRemaining < 0L) {
                if (this.latestLoginTTL != -1L) {
                    this.logger.info("TTL has expired, clearing the cookie store of {} cookies", (Object)this.latestCookies.size());
                    webDriver.manage().deleteAllCookies();
                    this.latestCookies.clear();
                }
                this.latestLoginTTL = Instant.now().getMillis();
                this.navigateToTheLoginLink(webDriver);
                if (this.jsEnabledAuth) {
                    for (int i = 0; i < this.credentials.size(); ++i) {
                        this.doFormLogin(webDriver, this.credentials.get(i), 0);
                    }
                } else if (!this.credentials.isEmpty()) {
                    this.logger.info("setCookiesFromHttpClientToWebDriver");
                    this.setCookiesFromHttpClientToWebDriver(webDriver);
                } else {
                    this.logger.info("No need to copy cookies");
                }
                this.latestCookies = webDriver.manage().getCookies();
            } else if (this.diagnosticMode) {
                this.logger.info("Cookies have not expired the TTL. Cookies still have {} ms life remaining.", (Object)ttlTimeRemaining);
            }
        }
    }

    private void navigateToTheLoginLink(WebDriver webDriver) {
        if (!this.credentials.isEmpty()) {
            StringBuilder loginPage = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.credentials.get(0).getLoginLink())) {
                loginPage.append(this.credentials.get(0).getLoginLink());
            } else if (StringUtils.isNotBlank((CharSequence)this.credentials.get(0).getAction())) {
                URI uri = URI.create(this.credentials.get(0).getAction());
                loginPage.append(uri.getScheme()).append("://").append(uri.getAuthority());
            } else {
                loginPage.append(this.credentials.get(0).getPort() == 443 ? "https://" : "http://").append(this.credentials.get(0).getHost());
                if (this.credentials.get(0).getPort() != 80 && this.credentials.get(0).getPort() != 443) {
                    loginPage.append(":").append(this.credentials.get(0).getPort());
                }
            }
            webDriver.get(loginPage.toString());
            new WebDriverWait(webDriver, Duration.ofSeconds(this.scriptTimeout)).until(wd -> ((JavascriptExecutor)wd).executeScript("return document.readyState", new Object[0]).equals("complete"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFormLogin(WebDriver webDriver, HttpCredential credential, int nthRetry) throws IOException {
        for (Map<String, String> params : credential.getMultiFormParams()) {
            try {
                boolean foundForm = this.submitFormIfPossible(webDriver, params);
                if (!foundForm) {
                    List<WebElement> allFrames = this.findElements(webDriver, By.xpath((String)"//iframe"), 5);
                    allFrames.addAll(this.findElements(webDriver, By.xpath((String)"//frame"), 5));
                    for (WebElement nextFrame : allFrames) {
                        try {
                            this.logger.info("Switching to frame id={}, href={}", (Object)nextFrame.getAttribute("id"), (Object)nextFrame.getAttribute("href"));
                            webDriver.switchTo().frame(nextFrame);
                            foundForm = this.submitFormIfPossible(webDriver, params);
                        }
                        finally {
                            webDriver.switchTo().defaultContent();
                        }
                        if (!foundForm) continue;
                        break;
                    }
                }
                if (!foundForm) {
                    StringBuilder formKeys = new StringBuilder();
                    params.keySet().forEach(key -> formKeys.append(" ").append((String)key));
                    this.logger.info("Couldn't find the form with login parameters {} on the current page or any frames / iframes in the body.", (Object)formKeys);
                }
                if (!this.diagnosticMode) continue;
                this.logger.info("Raw form response: {}", (Object)webDriver.getPageSource());
                if (webDriver.manage().getCookies() == null) continue;
                for (Cookie cookie : webDriver.manage().getCookies()) {
                    this.logger.info("Cookie from SmartLogin: {}", (Object)cookie.getValue());
                }
            }
            catch (WebDriverException e) {
                if (nthRetry == 2) {
                    throw new IOException("Attempted form login to " + credential.getLoginLink() + " 3 times and failed, giving up", e);
                }
                this.logger.warn("Failed to execute form login to {}, trying again...", (Object)credential.getAction(), (Object)e);
                this.doFormLogin(webDriver, credential, ++nthRetry);
            }
        }
        this.basicCookieStore.clear();
        this.setCookiesFromWebDriverToHttpClient(webDriver);
    }

    @VisibleForTesting
    void setCookiesFromWebDriverToHttpClient(WebDriver webDriver) {
        webDriver.manage().getCookies().forEach(c -> {
            try {
                BasicClientCookie newCookie = new BasicClientCookie(c.getName(), c.getValue());
                newCookie.setAttribute("domain", "true");
                newCookie.setDomain(c.getDomain());
                try {
                    newCookie.setExpiryDate(c.getExpiry());
                }
                catch (Exception dateParseException) {
                    this.logger.debug("Could not set expiry date for cookie {}: {}", (Object)c.getName(), (Object)dateParseException.getMessage());
                }
                newCookie.setPath(c.getPath());
                newCookie.setSecure(c.isSecure());
                this.basicCookieStore.addCookie((org.apache.http.cookie.Cookie)newCookie);
                this.logger.debug("Successfully transferred cookie {} from WebDriver to HttpClient", (Object)c.getName());
            }
            catch (Exception e) {
                this.logger.warn("Could not transfer cookie {} from WebDriver to HttpClient: {}", (Object)c.getName(), (Object)e.getMessage());
            }
        });
    }

    @VisibleForTesting
    void setCookiesFromHttpClientToWebDriver(WebDriver webDriver) {
        webDriver.manage().deleteAllCookies();
        HashMap cookiesByDomain = new HashMap();
        this.basicCookieStore.getCookies().forEach(cookie -> {
            String domain = cookie.getDomain();
            if (domain != null) {
                cookiesByDomain.computeIfAbsent(domain, k -> new ArrayList()).add(cookie);
            }
        });
        for (Map.Entry entry : cookiesByDomain.entrySet()) {
            String domain = (String)entry.getKey();
            List domainCookies = (List)entry.getValue();
            try {
                Object targetUrl;
                if (!this.isCookieDomainCompatible(webDriver.getCurrentUrl(), domain) && (targetUrl = this.ensureCorrectDomainForCookies(webDriver, domain)) != null) {
                    this.logger.debug("Navigating to {} to set cookies for domain {}", targetUrl, (Object)domain);
                    webDriver.get((String)targetUrl);
                    new WebDriverWait(webDriver, Duration.ofSeconds(5L)).until(wd -> ((JavascriptExecutor)wd).executeScript("return document.readyState", new Object[0]).equals("complete"));
                }
                targetUrl = domainCookies.iterator();
                while (targetUrl.hasNext()) {
                    org.apache.http.cookie.Cookie cookie2 = (org.apache.http.cookie.Cookie)targetUrl.next();
                    try {
                        this.logger.debug("Adding cookie {} for domain {}", (Object)cookie2.getName(), (Object)cookie2.getDomain());
                        Date expiryDate = null;
                        try {
                            expiryDate = cookie2.getExpiryDate();
                        }
                        catch (Exception dateException) {
                            this.logger.debug("Could not parse expiry date for cookie {}, using session cookie", (Object)cookie2.getName());
                        }
                        Cookie seleniumCookie = new Cookie(cookie2.getName(), cookie2.getValue(), cookie2.getDomain(), cookie2.getPath(), expiryDate, cookie2.isSecure());
                        webDriver.manage().addCookie(seleniumCookie);
                        this.logger.debug("Successfully added cookie {} for domain {}", (Object)cookie2.getName(), (Object)cookie2.getDomain());
                    }
                    catch (Exception e) {
                        this.logger.warn("Could not add cookie name={} from domain={} to WebDriver: {}", new Object[]{cookie2.getName(), cookie2.getDomain(), e.getMessage()});
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to set cookies for domain {}: {}", (Object)domain, (Object)e.getMessage());
            }
        }
    }

    private boolean isCookieDomainCompatible(String currentUrl, String cookieDomain) {
        if (currentUrl == null || cookieDomain == null) {
            return false;
        }
        try {
            URI currentUri = URI.create(currentUrl);
            String currentHost = currentUri.getHost();
            if (currentHost == null) {
                return false;
            }
            String normalizedCookieDomain = cookieDomain.startsWith(".") ? cookieDomain.substring(1) : cookieDomain;
            return currentHost.equals(normalizedCookieDomain) || currentHost.endsWith("." + normalizedCookieDomain);
        }
        catch (Exception e) {
            this.logger.debug("Error checking domain compatibility: {}", (Object)e.getMessage());
            return false;
        }
    }

    private String ensureCorrectDomainForCookies(WebDriver webDriver, String cookieDomain) {
        String[] protocols;
        if (cookieDomain == null) {
            return null;
        }
        String normalizedDomain = cookieDomain.startsWith(".") ? cookieDomain.substring(1) : cookieDomain;
        for (String protocol : protocols = new String[]{"https", "http"}) {
            String targetUrl = protocol + "://" + normalizedDomain;
            try {
                webDriver.get(targetUrl);
                return targetUrl;
            }
            catch (Exception e) {
                this.logger.debug("Could not navigate to {} for cookie domain {}: {}", new Object[]{targetUrl, cookieDomain, e.getMessage()});
            }
        }
        this.logger.warn("Could not navigate to any URL for cookie domain: {}", (Object)cookieDomain);
        return null;
    }

    private By getByFromFieldName(String fieldName) {
        if (fieldName.startsWith(";;BY_XPATH;;")) {
            return By.xpath((String)fieldName.replace(";;BY_XPATH;;", ""));
        }
        if (fieldName.startsWith(";;BY_ID;;")) {
            return By.id((String)fieldName.replace(";;BY_ID;;", ""));
        }
        if (fieldName.startsWith(";;BY_NAME;;")) {
            return By.name((String)fieldName.replace(";;BY_NAME;;", ""));
        }
        if (fieldName.startsWith(";;BY_CLASS_NAME;;")) {
            return By.className((String)fieldName.replace(";;BY_CLASS_NAME;;", ""));
        }
        if (fieldName.startsWith(";;BY_CSS_SELECTOR;;")) {
            return By.cssSelector((String)fieldName.replace(";;BY_CSS_SELECTOR;;", ""));
        }
        return By.name((String)fieldName);
    }

    private boolean submitFormIfPossible(WebDriver webDriver, Map<String, String> params) {
        List<WebElement> allForms = this.findElements(webDriver, By.xpath((String)"//form"), 1);
        for (WebElement nextForm : allForms) {
            if (!this.findAndSubmit(webDriver, params, nextForm)) continue;
            return true;
        }
        return this.findAndSubmit(webDriver, params, null);
    }

    private boolean findAndSubmit(WebDriver webDriver, Map<String, String> params, WebElement nextForm) {
        String submitButtonXPath = null;
        int numFound = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            WebElement inputElement;
            String nextParamName = entry.getKey();
            if (nextParamName.startsWith(SUBMIT_BUTTON_XPATH)) {
                submitButtonXPath = params.get(nextParamName).replace(SUBMIT_BUTTON_XPATH, "");
                ++numFound;
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)nextParamName)) continue;
            By by = null;
            if (nextParamName.startsWith(WHEN_XPATH)) {
                String[] whenSplit = nextParamName.split("::");
                if (whenSplit.length < 6) {
                    throw new WebConnectorException(this.getInvalidWhenXPathErrorMessage(nextParamName));
                }
                String whenXpath = whenSplit[2];
                String attributeNameOrText = whenSplit[3];
                String whenValue = whenSplit[4];
                if (StringUtils.isEmpty((CharSequence)attributeNameOrText) || !"text".equals(attributeNameOrText) && attributeNameOrText.startsWith("@")) {
                    throw new WebConnectorException(this.getInvalidWhenXPathErrorMessage(nextParamName));
                }
                String fieldByName = whenSplit[5];
                boolean itMatches = false;
                WebElement checkAgainst = this.getElementIfPresent(webDriver, nextForm, By.xpath((String)whenXpath), 1);
                if (checkAgainst != null) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)attributeNameOrText, (CharSequence)"text")) {
                        itMatches = checkAgainst.getText() != null && StringUtils.equalsIgnoreCase((CharSequence)checkAgainst.getText().trim(), (CharSequence)whenValue.trim());
                    } else if (attributeNameOrText.startsWith("@")) {
                        String attrName = attributeNameOrText.substring(1);
                        itMatches = StringUtils.equalsIgnoreCase((CharSequence)checkAgainst.getAttribute(attrName), (CharSequence)whenValue.trim());
                    }
                    if (itMatches) {
                        by = this.getByFromFieldName(fieldByName);
                    }
                }
            } else {
                by = this.getByFromFieldName(nextParamName);
            }
            if (by == null || (inputElement = this.getElementIfPresent(webDriver, nextForm, by, 1)) == null) continue;
            inputElement.click();
            inputElement.clear();
            inputElement.sendKeys(new CharSequence[]{params.get(nextParamName)});
            ++numFound;
        }
        if (numFound != 0) {
            if (submitButtonXPath == null && nextForm != null) {
                nextForm.submit();
            } else if (nextForm != null) {
                nextForm.findElement(By.xpath(submitButtonXPath)).click();
            } else if (submitButtonXPath != null) {
                webDriver.findElement(By.xpath(submitButtonXPath)).click();
            } else {
                this.logger.error("Input fields found, but not wrapped in a form tag. Need a submit button XPath to perform login.");
            }
            new WebDriverWait(webDriver, Duration.ofSeconds(this.scriptTimeout)).until(wd -> ((JavascriptExecutor)wd).executeScript("return document.readyState", new Object[0]).equals("complete"));
            try {
                Thread.sleep(SMART_FORM_LOGIN_EXTRA_WAIT_MS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            if (this.diagnosticMode) {
                this.logger.info("Cookies available after SmartFormLogin: {}", (Object)webDriver.manage().getCookies());
            }
            return true;
        }
        return false;
    }

    private String getInvalidWhenXPathErrorMessage(String nextParamName) {
        return "A ::whenXPath:: form param was found " + nextParamName + " But it is malformed. When using this param, it expects:\n  ::WhenXPath::XPath of element to check against::Either @attributeToCheckAgainst or text to check against the text of the element::Value To Match::The field name/id/xpath to set if the conditional is true\n  Example: ::WhenXPath:://div[@id='theQuestion']::text::What city were you born in?::;;BY_CLASS_NAME;;answer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebElement getElementIfPresent(WebDriver driver, WebElement form, By selector, int waitSecs) {
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(waitSecs));
        this.logger.debug("Is element present {}", (Object)selector);
        try {
            if (form == null) {
                WebElement webElement = driver.findElement(selector);
                return webElement;
            }
            WebElement webElement = form.findElement(selector);
            return webElement;
        }
        catch (NoSuchElementException e) {
            this.logger.debug("Couldn't find element {}", (Object)selector);
        }
        finally {
            driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(this.implicitWaitTimeout / 1000L));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<WebElement> findElements(WebDriver driver, By selector, int waitSecs) {
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(waitSecs));
        this.logger.debug("Is element present {}", (Object)selector);
        try {
            List list = driver.findElements(selector);
            return list;
        }
        finally {
            driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(this.implicitWaitTimeout / 1000L));
        }
    }
}

