/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.login;

import com.lucidworks.connector.plugins.web.fetcher.http.login.Form;
import com.lucidworks.connector.plugins.web.fetcher.http.login.FormLogins;
import com.lucidworks.connector.plugins.web.fetcher.http.login.HttpCredential;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartFormLogins {
    private final Logger logger = LoggerFactory.getLogger(FormLogins.class);
    private final boolean diagnosticMode;
    private final boolean isKerberosEnabled;
    private double lowestTTL = 9.223372036854776E18;
    private long latestLogin = -1L;
    private final TimeProvider timeProvider;
    private BasicCookieStore cookieStore;
    private List<HttpCredential> credentials = new ArrayList<HttpCredential>();

    public SmartFormLogins(HttpCredential[] allCredentials, boolean diagnosticMode, boolean isKerberosEnabled) {
        this(allCredentials, diagnosticMode, new TimeProvider(), isKerberosEnabled);
    }

    protected SmartFormLogins(HttpCredential[] allCredentials, boolean diagnosticMode, TimeProvider timeProvider, boolean isKerberosEnabled) {
        this.timeProvider = timeProvider;
        for (HttpCredential credential : allCredentials) {
            double credTtl;
            if (!credential.getType().equals("smartForm")) continue;
            this.credentials.add(credential);
            try {
                credTtl = credential.getTTL();
            }
            catch (NullPointerException e) {
                credTtl = 9.223372036854776E18;
            }
            this.lowestTTL = this.lowestTTL < credTtl ? this.lowestTTL : credTtl;
        }
        this.diagnosticMode = diagnosticMode;
        this.isKerberosEnabled = isKerberosEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(CloseableHttpClient client, BasicCookieStore cookieStore) throws IOException, URISyntaxException {
        SmartFormLogins smartFormLogins = this;
        synchronized (smartFormLogins) {
            this.cookieStore = cookieStore;
            if (this.latestLogin != -1L && (double)this.latestLogin + this.lowestTTL > (double)this.timeProvider.getCurrentTimeMillis()) {
                return;
            }
            if (this.latestLogin != -1L) {
                this.logger.info("TTL has expired, clearing the cookie store of {} cookies", (Object)cookieStore.getCookies().size());
                cookieStore.clear();
            }
            this.latestLogin = this.timeProvider.getCurrentTimeMillis();
            for (HttpCredential credential : this.credentials) {
                this.doFormLogin(client, credential, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFormLogin(CloseableHttpClient client, HttpCredential credential, int nthRetry) throws IOException, URISyntaxException {
        String loginLink = credential.getLoginLink();
        Form form = null;
        HttpClientContext context = null;
        String returnedHtml = null;
        for (Map<String, String> params : credential.getMultiFormParams()) {
            if (!this.isKerberosEnabled || !params.isEmpty()) {
                form = form == null ? this.getLoginForm(client, params, loginLink) : this.getLoginForm(returnedHtml, context, form.getActionURI().toASCIIString(), params);
                for (Map.Entry<String, String> e : params.entrySet()) {
                    form.setField(e.getKey(), e.getValue());
                }
            }
            try {
                CloseableHttpResponse response;
                context = HttpClientContext.create();
                if (params.isEmpty() && this.isKerberosEnabled) {
                    response = client.execute((HttpUriRequest)new HttpGet(loginLink), (HttpContext)context);
                } else {
                    HttpEntityEnclosingRequestBase request = this.getFormSubmitRequest(form);
                    response = client.execute((HttpUriRequest)request, (HttpContext)context);
                }
                try {
                    int status = response.getStatusLine().getStatusCode();
                    if (form != null) {
                        this.logger.info("Executed SAML login: [ action={} status={} ]", (Object)form.getActionURI(), (Object)status);
                        this.logResponseInfo(form.getActionURI().toASCIIString(), response, context);
                    }
                    returnedHtml = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (status >= 400) {
                        throw new IOException("Non-OK HTTP-status from form login: " + status + "; first 1k of raw form response: " + returnedHtml.substring(0, Math.min(returnedHtml.length(), 1024)));
                    }
                    if (!this.diagnosticMode) continue;
                    this.logger.info("Raw form response: {}", (Object)returnedHtml);
                    if (context.getCookieStore() == null) continue;
                    for (Cookie cookie : context.getCookieStore().getCookies()) {
                        this.logger.info("Cookie: {}", (Object)cookie.getValue());
                    }
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    response.close();
                }
            }
            catch (IOException e) {
                if (nthRetry == 2) {
                    throw new IOException("Attempted form login to " + form.getActionURI() + " 3 times and failed, giving up", e);
                }
                this.logger.warn("Failed to execute form login to {}, trying again...", (Object)credential.getAction(), (Object)e);
                this.doFormLogin(client, credential, ++nthRetry);
            }
        }
    }

    private HttpEntityEnclosingRequestBase getFormSubmitRequest(Form form) throws IOException {
        HttpPost request;
        switch (form.getMethod()) {
            case "POST": {
                request = new HttpPost(form.getActionURI());
                break;
            }
            case "PUT": {
                request = new HttpPut(form.getActionURI());
                break;
            }
            default: {
                this.logger.warn("Form method is {}. Defaulting to using a POST request.", (Object)form.getMethod());
                request = new HttpPost(form.getActionURI());
            }
        }
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setEntity((HttpEntity)form.toFormEntity());
        return request;
    }

    private URI getAbsoluteAction(Form form, URI uri) throws URISyntaxException {
        return URIUtils.resolve((URI)uri, (String)form.getAction());
    }

    protected Form getLoginForm(CloseableHttpClient client, Map<String, String> formParams, String loginLink) throws IOException, URISyntaxException {
        HttpGet get = new HttpGet(loginLink);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = client.execute((HttpUriRequest)get, (HttpContext)context);
        try {
            this.logResponseInfo(loginLink, response, context);
            if (200 <= response.getStatusLine().getStatusCode() && response.getStatusLine().getStatusCode() < 300) {
                Form form = this.getLoginForm(EntityUtils.toString((HttpEntity)response.getEntity()), context, loginLink, formParams);
                return form;
            }
            this.logger.error("Caught exception fetching the login page");
            throw new IOException("Unable to find login form starting at " + loginLink + ". Redirects terminated at " + this.getLastRedirect(context) + " with status code=" + response.getStatusLine().getStatusCode());
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            response.close();
        }
    }

    private void logResponseInfo(String url, CloseableHttpResponse response, HttpClientContext context) {
        Header[] cookies = response.getHeaders("Set-Cookie");
        int numCookies = cookies == null ? 0 : cookies.length;
        RedirectLocations redirectLocations = (RedirectLocations)context.getAttribute("http.protocol.redirect-locations");
        Integer statusCode = response.getStatusLine().getStatusCode();
        Integer redirectSize = redirectLocations == null ? null : Integer.valueOf(redirectLocations.size());
        String message = "HTTP Status " + statusCode + " while fetching " + url + ". Followed " + redirectSize + " redirects";
        if (!this.diagnosticMode) {
            this.logger.info(message + ". Set {} cookies", (Object)numCookies);
            return;
        }
        List cookieValues = Arrays.asList(cookies).stream().map(it -> it.getValue()).collect(Collectors.toList());
        this.logger.info(message + ": ({}). Set {} cookies: {}", new Object[]{StringUtils.join((Iterable)redirectLocations, (char)'\n'), numCookies, cookieValues});
    }

    private Form getLoginForm(String html, HttpClientContext context, String url, Map<String, String> formInputs) throws IOException, URISyntaxException {
        List<Form> forms = Form.parse(html);
        if (forms.isEmpty()) {
            throw new IOException("No form found while following '" + url + "' to '" + this.getLastRedirect(context) + "'");
        }
        if (formInputs == null || formInputs.isEmpty()) {
            return forms.get(0);
        }
        URI lastRedirect = this.getLastRedirect(context);
        if (lastRedirect == null) {
            lastRedirect = new URIBuilder(url).build();
        }
        for (Form form : forms) {
            form.setActionURI(this.getAbsoluteAction(form, lastRedirect));
            if (!form.hasInputs(formInputs.keySet().toArray(new String[0]))) continue;
            return form;
        }
        throw new IOException("Found " + forms.size() + " forms on '" + this.getLastRedirect(context) + "', but none matching the provided login parameters");
    }

    private URI getLastRedirect(HttpClientContext context) {
        RedirectLocations r = (RedirectLocations)context.getAttribute("http.protocol.redirect-locations");
        if (null != r && !r.isEmpty()) {
            return (URI)r.getAll().get(r.size() - 1);
        }
        return null;
    }

    public double getTTL() {
        return this.lowestTTL;
    }

    public void reset() {
        this.latestLogin = -1L;
        this.lowestTTL = 9.223372036854776E18;
        this.cookieStore.clear();
    }

    protected static class TimeProvider {
        protected TimeProvider() {
        }

        public long getCurrentTimeMillis() {
            return Instant.now().getEpochSecond();
        }
    }
}

