/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.login;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HttpCredential {
    public static final String BASIC_TYPE = "basic";
    public static final String DIGEST_TYPE = "digest";
    public static final String NTLM_TYPE = "ntlm";
    public static final String SAML_TYPE = "smartForm";
    public static final String FORM_TYPE = "form";
    public static final String TYPE = "type";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER_NAME = "username";
    public static final String PASSWORD = "password";
    public static final String PASSWORD_PARAM_NAME = "passwordParamName";
    public static final String REALM = "realm";
    public static final String DOMAIN = "domain";
    public static final String WORK_STATION = "workstation";
    public static final String ACTION = "action";
    public static final String TTL = "ttl";
    public static final String FORM_PARAMS = "paramsList";
    public static final String LOGIN_URL = "loginUrl";
    private Map<String, Object> credential;

    public String getType() {
        return (String)this.credential.get(TYPE);
    }

    public String getHost() {
        return (String)this.credential.get(HOST);
    }

    public int getPort() {
        return ((Number)this.credential.get(PORT)).intValue();
    }

    public String getRealm() {
        return (String)this.credential.get(REALM);
    }

    public String getUserName() {
        return (String)this.credential.get(USER_NAME);
    }

    public String getPassword() {
        return (String)this.credential.get(PASSWORD);
    }

    public String getDomain() {
        return (String)this.credential.get(DOMAIN);
    }

    public String getWorkstation() {
        return (String)this.credential.get(WORK_STATION);
    }

    public String getAction() {
        return (String)this.credential.get(ACTION);
    }

    public double getTTL() {
        return (Double)this.credential.get(TTL);
    }

    public String getLoginLink() {
        return (String)this.credential.get(LOGIN_URL);
    }

    public Map<String, String> getFormParams() {
        List<Map<String, String>> list = this.getMultiFormParams();
        return list.isEmpty() ? null : list.get(0);
    }

    public List<Map<String, String>> getMultiFormParams() {
        if (!this.credential.containsKey(FORM_PARAMS)) {
            return Collections.emptyList();
        }
        if (this.credential.get(FORM_PARAMS) instanceof List) {
            return (List)this.credential.get(FORM_PARAMS);
        }
        return Arrays.asList((Map)this.credential.get(FORM_PARAMS));
    }

    public int hashCode() {
        StringBuilder hashStr = new StringBuilder();
        for (Object param : this.credential.values()) {
            hashStr.append(param.toString());
        }
        return hashStr.toString().hashCode();
    }

    public static HttpCredential getCredential(Map<String, Object> map) {
        HttpCredential httpCredential = new HttpCredential();
        httpCredential.credential = map;
        return httpCredential;
    }
}

