/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.login;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Form
implements Iterable<Map.Entry<String, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(Form.class);
    private final String action;
    private final String method;
    private Map<String, String> fields = new HashMap<String, String>();
    private URI actionURI;

    public Form(String action, String method) {
        this.action = action;
        this.method = method;
    }

    public UrlEncodedFormEntity toFormEntity() throws UnsupportedEncodingException {
        return new UrlEncodedFormEntity(this.fields.entrySet().stream().map(e -> new BasicNameValuePair((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
    }

    public void setField(String key, String value) {
        this.fields.put(key, value);
    }

    public String getField(String key) {
        return this.fields.get(key);
    }

    public boolean hasField(String key) {
        return this.fields.containsKey(key);
    }

    public String getAction() {
        return this.action;
    }

    public String getMethod() {
        return this.method;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.fields.entrySet().iterator();
    }

    public boolean hasInputs(String ... params) {
        for (String param : params) {
            if (this.hasField(param)) continue;
            return false;
        }
        return true;
    }

    public static final List<Form> parse(String html) {
        ArrayList<Form> forms = new ArrayList<Form>();
        for (Element element : Jsoup.parse((String)html).select("form")) {
            Form form = new Form(element.attr("action"), element.attr("method").isEmpty() ? HttpMethod.POST.name() : element.attr("method").toUpperCase());
            for (Element input : element.select("input")) {
                String name = input.attr("name");
                String value = input.attr("value");
                if (value == null && input.hasText()) {
                    value = input.text();
                }
                if (name == null || name.isEmpty()) continue;
                form.setField(name, value);
            }
            forms.add(form);
        }
        return forms;
    }

    public void setActionURI(URI actionURI) {
        this.actionURI = actionURI;
    }

    public URI getActionURI() {
        if (this.actionURI != null) {
            return this.actionURI;
        }
        try {
            return new URIBuilder(this.action).build();
        }
        catch (URISyntaxException e) {
            LOG.warn("Exception building actionURI for action {}, {} ", (Object)this.action, (Object)e.getMessage());
            return null;
        }
    }

    public String toString() {
        return "[ actionURI:" + this.actionURI + ", action:" + this.action + ", method:" + this.method + ", fields=" + this.fields + " ]";
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        PATCH,
        OPTIONS;

    }
}

