/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.login;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.config.CrawlAuthenticationConfig;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.http.login.FormLogins;
import com.lucidworks.connector.plugins.web.fetcher.http.login.HttpCredential;
import com.lucidworks.connector.plugins.web.fetcher.http.login.HttpCredentialMapper;
import com.lucidworks.connector.plugins.web.fetcher.http.login.SmartFormLogins;
import java.util.ArrayList;
import java.util.List;

public class CredentialsWrapper {
    private final ArrayList<HttpCredential> credentials;
    private boolean hasHttpLogins;
    private boolean hasFormLogins;
    private boolean hasSmartFormLogins;
    private FormLogins formLogins;
    private SmartFormLogins smartFormLogins;

    public List<HttpCredential> getCredentials() {
        return this.credentials;
    }

    @Inject
    public CredentialsWrapper(WebConfig config) {
        CrawlAuthenticationConfig authentication = config.properties().crawlAuthenticationConfig();
        this.credentials = new ArrayList();
        authentication.basicAuth().stream().map(a -> HttpCredentialMapper.mapBasic(a._data())).forEach(this.credentials::add);
        authentication.digestAuth().stream().map(a -> HttpCredentialMapper.mapDigest(a._data())).forEach(this.credentials::add);
        authentication.formAuth().stream().map(a -> HttpCredentialMapper.mapForm(a._data())).forEach(this.credentials::add);
        authentication.samlAuth().stream().map(a -> HttpCredentialMapper.mapSaml(a._data())).forEach(this.credentials::add);
        authentication.ntlmAuth().stream().map(a -> HttpCredentialMapper.mapNtlm(a._data())).forEach(this.credentials::add);
        HttpCredential[] creds = this.credentials.toArray(new HttpCredential[0]);
        for (HttpCredential credential : this.credentials) {
            if (credential.getType().equalsIgnoreCase("form")) {
                this.setHasFormLogins(true);
                continue;
            }
            if (credential.getType().equalsIgnoreCase("smartForm")) {
                this.setHasSmartFormLogins(true);
                continue;
            }
            this.setHasHttpLogins(true);
        }
        if (this.hasFormLogins()) {
            this.setFormLogins(new FormLogins(creds, config.diagnosticLogging()));
        }
        if (this.hasSmartFormLogins()) {
            this.setSmartFormLogins(new SmartFormLogins(creds, config.diagnosticLogging(), false));
        }
    }

    public boolean hasHttpLogins() {
        return this.hasHttpLogins;
    }

    public void setHasHttpLogins(boolean hasHttpLogins) {
        this.hasHttpLogins = hasHttpLogins;
    }

    public boolean hasFormLogins() {
        return this.hasFormLogins;
    }

    public void setHasFormLogins(boolean hasFormLogins) {
        this.hasFormLogins = hasFormLogins;
    }

    public boolean hasSmartFormLogins() {
        return this.hasSmartFormLogins;
    }

    public void setHasSmartFormLogins(boolean hasSmartFormLogins) {
        this.hasSmartFormLogins = hasSmartFormLogins;
    }

    public FormLogins getFormLogins() {
        return this.formLogins;
    }

    public void setFormLogins(FormLogins formLogins) {
        this.formLogins = formLogins;
    }

    public SmartFormLogins getSmartFormLogins() {
        return this.smartFormLogins;
    }

    public void setSmartFormLogins(SmartFormLogins smartFormLogins) {
        this.smartFormLogins = smartFormLogins;
    }
}

